﻿using System;
using System.Windows.Forms;
using XdsObjects;
using MedicalConnections.Security;
using XdsObjects.Enums;

namespace XDS_Gateways
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        #region "Variables and Constants"
        XCAInitiatingGateway InitiatingGateway;
        XCARespondingGateway RespondingGateway;
        XdsDomain RespondingConfig;
        #endregion

        #region "Setup Routines"
        private void Setup()
        { 
            // Set up logging
            XdsGlobal.LogToFile(@"c:\xds log files", LogLevel.FullXmlIn | LogLevel.FullXmlOut, 60);

            // We don't do TLS in this sample, ask if you want sample code for TLS
            SetupInitiatingGateway();
            SetupRespondingGateway();
        }
        
        // Set up the Initiating Gateway
        private void SetupInitiatingGateway()
        {
            ITlsClientSecurity sec = null;
            // Set up the listen address of the Initiating Gateway
            InitiatingGateway = new XCAInitiatingGateway(InitHomeCommunityID.Text,
                InitQUnsecure.Text, InitRUnsecure.Text);
            
            // Set up the responding gateway
            GatewayConfiguration respondingConfig = new GatewayConfiguration();
            respondingConfig.isLocalRegistry = false;
            respondingConfig.RegistryEndpoint = new WebServiceEndpoint(RespQUnsecure.Text, sec);
            respondingConfig.RetrieveGateway = new WebServiceEndpoint(RespRUnsecure.Text, sec);
            
            // Link the initiating gateway to the responding gateway
            // Could repeat multiple times if we had multiple  responding gateways
            InitiatingGateway.ActiveGateways.Add(respondingConfig);
        }

        // Set up the responding gateway to talk to the public NIST registry repository
        private void SetupRespondingGateway()
        {
            string NIST_Registry = "http://ihexds.nist.gov:12080/tf6/services/xdsregistryb";
            string NIST_Repository = "http://ihexds.nist.gov:12080/tf6/services/xdsrepositoryb";
            string NIST_RepositoryUID = "1.19.6.24.109.42.1.5";

            RespondingConfig = new XdsDomain();
            RespondingConfig.RegistryEndpoint = new WebServiceEndpoint(NIST_Registry);
            RespondingConfig.RepositoryAddresses.Add(NIST_RepositoryUID, new WebServiceEndpoint(NIST_Repository));
           
            // Setup the listen address of the Responding Gateway
            RespondingGateway = new XCARespondingGateway(RespondingConfig, RespHomeCommunityID.Text,
                RespQUnsecure.Text, RespRUnsecure.Text);
        }

        #endregion

        #region "UI Handler"
        
        private void MainForm_Load(object sender, EventArgs e)
        {
            Setup();
        }
        
        #endregion
    }
}
