﻿using System;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.IO;
using XdsObjects;
using XdsObjects.Enums;

namespace XDS_Document_Source__Simple_Version_
{
    public partial class DocSourceForm : Form
    {
        public DocSourceForm()
        {
            InitializeComponent();
        }

        #region "Variables"
        private XdsDomain xds;
        private DocConsumer consumerForm;
        #endregion

        #region "UI Handlers"
        private void MainForm_Load(object sender, EventArgs e)
        {            
            Setup();            
        }       

        private void SendBTN_Click(object sender, EventArgs e)
        {
            if (!String.IsNullOrEmpty(SummaryText.Text))
            {
                SubmitDocument();      
                // Display the current Patient ID
                consumerForm.PIDText.Text = Properties.Settings.Default.PatientIDExtension + "^^^&" + Properties.Settings.Default.PatientIDRoot + "&ISO";
                // Display the Consumer Form so we can query/retrieve the document we just submitted.
                consumerForm.ShowDialog();
            }
        }
        #endregion

        #region "Set up"
        /// <summary>
        /// Setup Routine
        /// </summary>
        private void Setup()
        {
            // Set up Logging
            XdsGlobal.LogToFile(@"c:\xds log files", LogLevel.FullXmlIn | LogLevel.FullXmlOut, 60);

            xds = new XdsDomain();
            // Where to send the Document to
            xds.SubmissionRepositoryEndpoint = new WebServiceEndpoint("http://localhost:8080/MyRepository");

            // Allocate a new Patient using the NIST patient allocation web service
            if (string.IsNullOrEmpty(Properties.Settings.Default.PatientIDExtension))
                GetNewPatientID();

            // Display the Current Patient ID
            PIDLabel.Text  = Properties.Settings.Default.PatientIDExtension + "^^^&" + Properties.Settings.Default.PatientIDRoot + "&ISO";
            consumerForm = new DocConsumer();
        }

        private void GetNewPatientID()
        {
            // Public NIST patient allocation web wervice
            // Check the following webpage to see what it does
            string NISTService = "http://ihexds.nist.gov:12080/xdstools/pidallocate";
            string AssigningAuthority = "&1.3.6.1.4.1.21367.2005.3.7&ISO";

            HttpWebRequest r = (HttpWebRequest)WebRequest.Create(NISTService);
            r.Method = "POST";
            byte[] byteArray = Encoding.UTF8.GetBytes("aa=" + System.Web.HttpUtility.UrlEncode(AssigningAuthority));
            r.ContentType = "application/x-www-form-urlencoded";
            r.GetRequestStream().Write(byteArray, 0, byteArray.Length);
            r.GetRequestStream().Close();
            StreamReader sr = new StreamReader(r.GetResponse().GetResponseStream());

            string[] lines = sr.ReadToEnd().Split(new char[] { '\n' });

            // We have a new PatientID
            // Strip the new PatientID into Root and Extension
            string patientID = lines[lines.Length - 2];//
            string[] ss = patientID.Split(new char[] { '&' });
            Properties.Settings.Default.PatientIDExtension = patientID.Substring(0, patientID.IndexOf("^"));
            Properties.Settings.Default.PatientIDRoot = ss[1];
        }

        #endregion

        #region "Document Submission"
        private void SubmitDocument()
        { 
            // Create a new Patient
            XdsPatient patient = new XdsPatient();
            patient.Prefix = "Mr.";
            patient.FamilyName = "Patient";
            patient.GivenName = "Test";
            patient.Sex = "M";
            patient.DOB = DateTime.Now;
            patient.Address = "WALES-UK";

            // Format of Full Patient ID: Extension^^^&Root&ISO 
            patient.ID_Root = Properties.Settings.Default.PatientIDRoot;
            patient.ID_Extension = Properties.Settings.Default.PatientIDExtension;

            // Create a new SubmissionSet
            XdsSubmissionSet ss = new XdsSubmissionSet();
            ss.PatientInfo = patient;
            ss.Authors.Add(new XdsAuthor("Dr. WHO", new XdsMultiString("Institution X"), new XdsMultiString("Head of Science Research Group"), new XdsMultiString("Science Fiction"), new XdsMultiString("TelCom")));
            ss.SourceID = "1.3.6.1.4.1.21367.1234567"; // Sample UID of this Document Source
            ss.ContentType = new XdsCode("Connect-a-thon contentTypeCodes", "Discharge summarization", "Discharge summarization");

            // Create a new XdsDocument object from the Summary Text
            byte[] data = Encoding.ASCII.GetBytes(SummaryText.Text);
            XdsDocument doc = new XdsDocument(data);
            doc.Comments = "Discharge Summary";
            doc.Title = "DischargeSummaryDoc_1";
            doc.RepositoryUniqueId = "1.19.6.24.109.42.1.5"; // repository uniqued ID is required, we use NIST public repository for this sample
            doc.PatientInfo = patient;
            doc.MimeType = "text/plain";

            doc.Authors.Add(new XdsAuthor("Dr_Author_WHO", new XdsMultiString("Institution X"), new XdsMultiString("Head of Science Research Group"), new XdsMultiString("Science Fiction"), new XdsMultiString("TelCom")));
            doc.ClassCode = new XdsCode("Connect-a-thon classCodes", "Discharge summarization", "Discharge summarization");
            doc.TypeCode = new XdsCode("LOINC", "28574-2", "Discharge Note");
            doc.FormatCode = new XdsCode("Connect-a-thon formatCodes", "ScanTEXT/IHE 1.x", "ScanTEXT/IHE 1.x");
            doc.HealthCareFacilityTypeCode = new XdsCode("Connect-a-thon healthcareFacilityTypeCodes", "Outpatient", "Outpatient");
            doc.PracticeSettingCode = new XdsCode("Connect-a-thon practiceSettingCodes", "General Medicine", "General Medicine");
            doc.ConfidentialityCodes.Add(new XdsCode("Connect-a-thon confidentialityCodes", "N", "Normal"));

            // Add Document to SubmissionSet. 
            // You can have multiple documents in one SubmissionSet.
            // You can also have folders (XdsFolder which can have one or more XdsDocuments) within SubmissionSet
            ss.Documents.Add(doc); 

            // Send the Document             
            XdsRegistryResponse rr = xds.ProvideAndRegisterDocumentSet(ss);
            // Display the Submission Result
            MessageBox.Show(rr.Status.ToString());
        }
        #endregion
    }
}
