﻿using System.Windows.Forms;
using System.Data.Entity;

namespace XdsRegistry
{
    public partial class Form1 : Form
    {
        Registry Reg = new Registry();
        Registry.LogMessageHandler LogMessageHandler;

        public Form1()
        {
            InitializeComponent();

            LogMessageHandler = new Registry.LogMessageHandler(logMessageHandler);

            //uncomment to drop DB and populate patient table
            Database.SetInitializer(new ContextInitializer());

            Reg.LogMessageEvent += LogMessageHandler;

            Reg.StartListen();
        }

        void logMessageHandler(string msg)
        {
            if (InvokeRequired)
            {
                Invoke(LogMessageHandler, new object[] { msg });

            }
            else
            {
                logWindow.AppendText(msg + "\n");
            }
        }
    }
}
