﻿using System;
using System.Windows.Forms;
using System.IO;

namespace XdsRepository
{
    public partial class RepositoryForm : Form
    {
        Repository.LogMessageHandler myLogMessageHandler;
        Repository Rep = new Repository();

        public RepositoryForm()
        {
            InitializeComponent();
        }

        private void RepositoryForm_Load(object sender, EventArgs e)
        {
            myLogMessageHandler = new Repository.LogMessageHandler(logMessageHandler);
            Rep.LogMessageEvent += myLogMessageHandler;            
            Directory.CreateDirectory(Repository.StoragePath);
        }

        void logMessageHandler(string msg)
        {
            if (InvokeRequired)
                Invoke(myLogMessageHandler, new object[] { msg });
            else
                logWindow.AppendText(msg + "\n");
        }
    }
}
