﻿using System;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using System.Net;
using XdsObjects;
using XdsObjects.Enums;
using System.Collections.Generic;

namespace XDS_Document_Source_Consumer__Advanced_Version_
{
    public partial class DocSourceForm : Form
    {
        public DocSourceForm()
        {
            InitializeComponent();

            string patientID = "e6b7e7213b14472^^^&1.3.6.1.4.1.21367.2005.3.7&ISO";
            PRpIDExtText.Text = patientID.Substring(0, patientID.IndexOf("^"));
            Properties.Settings.Default.PatientIDExtension = PRpIDExtText.Text;
            string[] ss = patientID.Split(new char[] { '&' });
            PRpIDRootText.Text = ss[1];
            Properties.Settings.Default.PatientIDRoot = ss[1];
            List<string> list = new List<string>();
            list.Add("New Folder");
            listBox1.DataSource = list;
            listBox1.ClearSelected();
        }

#region "Variables"
        private XdsDomain xds;
        private DocConsumer consumerForm;
#endregion

#region "Set up routine"
        private void Setup()
        {
            // Start logging
            XdsGlobal.LogToFile(@"C:\Xds Log Files", LogLevel.FullXmlIn | LogLevel.FullXmlOut, 60);

            // The repository address - where to send the document to
            xds = new XdsDomain();
            xds.SubmissionRepositoryEndpoint = new WebServiceEndpoint("http://localhost:8080/MyRepository");
            xds.RegistryEndpoint = new WebServiceEndpoint("http://localhost:8090/MyRegistry");
            
            // Load the codes from external XML file
            XmlDocument codes = new XmlDocument();
            codes.Load(Application.StartupPath + @"\..\..\Files\codes.xml");

            // Display Repository Address and its UID
            RepAddrText.Text = "http://localhost:8080/MyRepository";
            RepUIDText.Text = "1.19.6.24.109.42.1.5";

            // Sample UID for this document source
            SourceIDText.Text = "1.3.6.1.4.1.21367.1234567";

            if (string.IsNullOrEmpty(Properties.Settings.Default.PatientIDExtension))
                GetNewPatientID();
            else
            {
                PRpIDRootText.Text = Properties.Settings.Default.PatientIDRoot;
                PRpIDExtText.Text = Properties.Settings.Default.PatientIDExtension;
            }
            consumerForm = new DocConsumer();
        }
#endregion

#region "UI Handler"
        private void DocSourceForm_Load(object sender, EventArgs e)
        {
            Setup();
        }

        private void PopulateComboBox(XmlDocument codes, string name, ComboBox box)
        {
            XmlNodeList q = codes.SelectNodes("/Codes/CodeType[@name='" + name + "']/Code");

            foreach (XmlNode qq in q)
            {
                box.Items.Add(new XdsCode(qq.Attributes["codingScheme"].Value, qq.Attributes["code"].Value, qq.Attributes["display"].Value));
            }
            box.SelectedItem = box.Items[0];
        }

        /// <summary>
        /// Select document to be submitted
        /// </summary>        
        private void PRBrowseDocumentBTN_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.FileName = "";
            dlg.Title = "Load Document";
            dlg.ShowDialog();
            if (dlg.FileName != "")
                FilePathText.Text = dlg.FileName;
        }

        /// <summary>
        /// Send document to Repository
        /// </summary>        
        private void SubmitBTN_Click(object sender, EventArgs e)
        {
            if (!String.IsNullOrEmpty(FilePathText.Text))
            {
                SubmitDocument();
                consumerForm.PIDText.Text = Properties.Settings.Default.PatientIDExtension + "^^^&" + Properties.Settings.Default.PatientIDRoot + "&ISO";
                consumerForm.ShowDialog();
            }
            else
                MessageBox.Show("Load a Document First");
        }

        /// <summary>
        /// Get a new Patient ID from the NIST patient allocation web service
        /// </summary>
        private void NewPatientBTN_Click(object sender, EventArgs e)
        {
            GetNewPatientID();
        }

        /// <summary>
        /// Get a new Patient ID from the NIST patient allocation web service
        /// </summary>
        private void GetNewPatientID()
        {
            // Public NIST patient allocation web wervice
            // Check the following webpage to see what it does
            string NISTService = "http://ihexds.nist.gov:12080/xdstools/pidallocate";
            string AssigningAuthority = "&1.3.6.1.4.1.21367.2005.3.7&ISO";

            HttpWebRequest r = (HttpWebRequest)WebRequest.Create(NISTService);
            r.Method = "POST";
            byte[] byteArray = Encoding.UTF8.GetBytes("aa=" + System.Web.HttpUtility.UrlEncode(AssigningAuthority));
            r.ContentType = "application/x-www-form-urlencoded";
            r.GetRequestStream().Write(byteArray, 0, byteArray.Length);
            r.GetRequestStream().Close();
            StreamReader sr = new StreamReader(r.GetResponse().GetResponseStream());

            string[] lines = sr.ReadToEnd().Split(new char[] { '\n' });

            // //We have a new PatientID
            // //Strip the new PatientID into Root and Extension
            string patientID = lines[lines.Length - 2];

            //string patientID = "e6b7e7213b14472^^^&1.3.6.1.4.1.21367.2005.3.7&ISO";


            PRpIDExtText.Text = patientID.Substring(0, patientID.IndexOf("^"));
            Properties.Settings.Default.PatientIDExtension = PRpIDExtText.Text;

            string[] ss = patientID.Split(new char[] { '&' });
            PRpIDRootText.Text = ss[1];
            Properties.Settings.Default.PatientIDRoot = ss[1];
        }
#endregion

#region "Document Submission"
        private void SubmitDocument()
        {
            // Create a new Patient
            XdsPatient patient = new XdsPatient();
            patient.Prefix = PRpTitleText.Text;
            patient.FamilyName = PRpSurnameName.Text;
            patient.GivenName = PRpGivenName.Text;
            patient.Sex = PRpSex.Text;
            patient.DOB = Convert.ToDateTime(PRpDOB.Text);
            patient.Address = PRpAddrText.Text;

            // Format of Full Patient ID - Extension^^^&Root&ISO 
            patient.ID_Root = PRpIDRootText.Text;
            patient.ID_Extension = PRpIDExtText.Text;

            // Create a new SubmissionSet
            XdsSubmissionSet ss = new XdsSubmissionSet();
            ss.PatientInfo = patient;
            ss.Authors.Add(new XdsAuthor(PRAutNameText.Text, new XdsMultiString(PRAutInstText.Lines), new XdsMultiString(PRAutRoleText.Lines), new XdsMultiString(PRAutSpecText.Lines),new XdsMultiString("TelCom")));
            ss.SourceID = SourceIDText.Text; // UID of this Document Source
            ss.ContentType = new XdsCode("Connect-a-thon contentTypeCodes", "Discharge summarization", "Discharge summarization");

            // Create a new XdsDocument from File
            XdsDocument doc = new XdsDocument(FilePathText.Text);
            doc.Comments = PRDocDescripText.Text;
            doc.Title = PRDocumentNameText.Text;
            doc.RepositoryUniqueId = RepUIDText.Text; // repository uniqued ID is required
            doc.PatientInfo = patient;

            doc.ClassCode = new XdsCode("Connect-a-thon classCodes", "Discharge summarization", "Discharge summarization");
            doc.TypeCode = new XdsCode("LOINC", "28574-2", "Discharge Note");
            doc.FormatCode = new XdsCode("Connect-a-thon formatCodes", "ScanTEXT/IHE 1.x", "ScanTEXT/IHE 1.x");
            doc.HealthCareFacilityTypeCode = new XdsCode("Connect-a-thon healthcareFacilityTypeCodes", "Outpatient", "Outpatient");
            doc.PracticeSettingCode = new XdsCode("Connect-a-thon practiceSettingCodes", "General Medicine", "General Medicine");
            doc.ConfidentialityCodes.Add(new XdsCode("Connect-a-thon confidentialityCodes", "N", "Normal"));

            // doc.MimeType will be set automatically unless it's created via a stream

            doc.Authors.Add(new XdsAuthor(PRAutNameText.Text, new XdsMultiString(PRAutInstText.Lines), new XdsMultiString(PRAutRoleText.Lines), new XdsMultiString(PRAutSpecText.Lines), new XdsMultiString("TelCom")));

            ss.Documents.Add(doc); // Add Document to SubmissionSet. You can also have folders (XdsFolder) within SubmissionSet
            
            //Add Document to selected folder?
            if (listBox1.SelectedIndex != -1)
            {
                XdsFolder folder;
                if (listBox1.SelectedIndex == 0) //new folder
                    folder = new XdsFolder();
                else
                {
                    folder = new XdsFolder(listBox1.SelectedItem.ToString());
                    folder.AlreadyExists = true;
                }

                folder.Documents.Add(doc);
                ss.Folders.Add(folder);
            }

            // Send the Document              
            XdsRegistryResponse rr = xds.ProvideAndRegisterDocumentSet(ss);
            MessageBox.Show(rr.Status.ToString());
        }
#endregion

        private void Btn_Find_Folders_Click(object sender, EventArgs e)
        {
            XdsQueryRequest q = new XdsQueryRequest();
            q.PatientId = PRpIDExtText.Text + "^^^&" + PRpIDRootText.Text + "&ISO";//"e6b7e7213b14472^^^&1.3.6.1.4.1.21367.2005.3.7&ISO";
            q.QueryReturnType = QueryReturnType.LeafClass;
            q.QueryType = QueryType.FindFolders;           
            q.FolderStatus = AvailabilityStatusCode.Approved;

            // Send the Document              
            XdsQueryResponse resp = xds.RegistryStoredQuery(q);

            List<string> list = new List<string>();
            list.Add("New Folder");
            foreach (var o in resp.ReturnedFolders)
            {
                list.Add(o.UUID.ToString());
            }
            listBox1.DataSource = list;
            listBox1.ClearSelected();
        }
    }
}
