﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace KeyObjectNote
{
    public static class SampleExtensions
    {
        public const string IMAGE_FOLDER_2D = "2D";
        public const string IMAGE_FOLDER_3D = "3D";
        private const string SampleProjects = "SampleProjects";
        private const string SampleImages = "SampleImages";
        private const string ErrorMessage = "Error while getting parent folder";

        public static string GetSampleImageFolderPath()
        {
            try
            {

                DirectoryInfo p = new DirectoryInfo(Path.GetDirectoryName(Application.ExecutablePath));
                while (p?.Exists ?? false)
                {

                    if (p.Name == SampleProjects)
                    {
                        p = p.Parent;
                        return Path.Combine(p.FullName, SampleImages);
                    }
                    p = p.Parent;
                }

            }
            catch (Exception ex)
            {
                Exception exception = new Exception(ErrorMessage, ex);
                throw exception;
            }
            return string.Empty;
        }
    }
}
