using System;
using System.Windows.Forms;
using DicomObjects;
using System.Security.Cryptography.X509Certificates;
using System.Net.Security;
using DicomObjects.EventArguments;
using MedicalConnections.Security;


namespace SecureConnection_SCP
{
    public partial class Form1 : Form
    {
        DicomServer server;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            server = new DicomServer();
            server.VerifyReceived +=server_VerifyReceived;
            TlsServerWindows serverSecurity = new TlsServerWindows
                {
                    ClientAuthentication = true,
                    Certificate = new X509Certificate2(SecureConnectionSCP.Properties.Resources.serverCert),
                    CertificateValidationCallback = MyRemoteCertificateChecker
                };
            server.Listen(104, serverSecurity);
        }

        void server_VerifyReceived(object sender, VerifyReceivedArgs e)
        {
            e.Status = 0;            
        }
        private bool MyRemoteCertificateChecker(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            // Check Client Certificate, if invalid return false
            return true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            server.UnlistenAll();
        }
    }
}