﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace DicomSecurityDemo
{
    public static class SampleExtensions
    {
        public const string IMAGE_FOLDER_2D = "2D";
        public const string IMAGE_FOLDER_3D = "3D";

        public static string GetSampleImageFolderPath()
        {
            try
            {

                DirectoryInfo p = new DirectoryInfo(Path.GetDirectoryName(Application.ExecutablePath));
                while (p?.Exists ?? false)
                {

                    if (p.Name == "SampleProjects")
                    {
                        p = p.Parent;
                        return Path.Combine(p.FullName, "SampleImages");
                    }
                    p = p.Parent;
                }

            }
            catch (Exception ex)
            {
                throw new Exception($"Error while getting parent folder", ex);
            }
            return "";
        }
    }
}
