﻿using Org.BouncyCastle.Asn1;
using Org.BouncyCastle.Cms;
using Org.BouncyCastle.Security;
using System.IO;

namespace DicomSecurityDemo
{
    // This samples shows how to use Cryptographic Message Syntax (CMS), which is the DICOM-defined means
    // to apply encryption with simple password protection to DICOM files.

    public static class BouncyCastleCmsEncryption
    {
        public static int EncryptionInterations = 1000;
        public static string EncryptionOID = "2.16.840.1.101.3.4.1.42";
        static SecureRandom random = new SecureRandom();

        public static Stream Encrypt(Stream OutputStream, string Password)
        {
            byte[] salt = random.GenerateSeed(16);

            CmsEnvelopedDataStreamGenerator cms = new CmsEnvelopedDataStreamGenerator(random);

            CmsPbeKey key = new Pkcs5Scheme2PbeKey(Password.ToCharArray(), salt, EncryptionInterations);
            cms.AddPasswordRecipient(key, EncryptionOID);
            return cms.Open(OutputStream, EncryptionOID);
        }

        public static Stream Decrypt(Stream InputStream, string Password)
        {
            CmsEnvelopedDataParser cms = new CmsEnvelopedDataParser(InputStream);
            RecipientID Selector = new RecipientID();

            RecipientInformation recipient = cms.GetRecipientInfos().GetFirstRecipient(Selector);

            PasswordRecipientInformation pwinfo = (PasswordRecipientInformation)recipient;
            DerSequence q = (DerSequence)pwinfo.KeyDerivationAlgorithm.Parameters;

            byte[] salt = ((DerOctetString)q[0]).GetOctets();
            int interations = ((DerInteger)q[1]).Value.IntValue;

            return recipient.GetContentStream(new Pkcs5Scheme2PbeKey(Password.ToCharArray(), salt, interations)).ContentStream;
        }
    }
}

