﻿using DicomObjects.DicomUIDs;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace TestApplication
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void loadBTN_Click(object sender, EventArgs e)
        {
            OpenFileDialog d = new OpenFileDialog();
            string dir = Environment.CurrentDirectory;
            d.InitialDirectory = Path.GetFullPath(Path.Combine(dir, @"..\..\..\"));
            if (d.ShowDialog() == DialogResult.OK && !string.IsNullOrEmpty(d.FileName))
            {
                viewer.Images.Clear();
                viewer.Images.Read(d.FileName);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            viewer.MakeControl += Viewer_MakeControl;
        }

        private Control Viewer_MakeControl(DicomObjects.EventArguments.MakeControlArgs e)
        {
            if (e.Image.SOPClass == SOPClasses.GeneralECGWaveform
             || e.Image.SOPClass == SOPClasses.TwelveLeadECGWaveform)
            {
                var c = new ECGControl.MyECGControl();
                c.LoadECG(e.Image.DataSet);      
                return c;
            }
            return null;
        }
    }
}
