using System;
using System.Windows.Forms;
using DicomObjects;
using DicomObjects.Enums;

namespace DicomObjects_V8_Sample_Viewer
{
	/// <summary>
	/// Summary description for RetrieveDialogType.
	/// </summary>
	public class RetrieveDialogType : Form
	{
		private TextBox QueryPatientName;
		private TreeView Tree;
		private readonly System.ComponentModel.Container components = null;
        OptionsBoxType OptionsBox;
		DicomViewer viewer1;
		private GroupBox PatientIDBox;
		DicomQuery query;			
		DicomDataSetCollection res;

		private const string StudyText = "STUDY";
		private const string StudyListRetrievingMessage = "Please wait, while the study list is being retrieved";
		private const string SeriesRetrievingMessage = "Please wait, while the series list is being retrieved";
		private const string ImagesRetrievingMessage = "Please wait, while the Image list is retrieved";
		private const string InvalidLevel = "Invalid Level";
		private const string MoveStatusText = "Move Status -- ";

		public RetrieveDialogType()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
            if (disposing && components != null)
            {
                components.Dispose();
            }
            base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            PatientIDBox = new GroupBox();
			Button Query = new Button();
            QueryPatientName = new TextBox();
			Label label1 = new Label();
            Tree = new TreeView();
            Button RetrieveBTN = new Button();
            Button ResetBTN = new Button();
            Button CloseBTN = new Button();
            PatientIDBox.SuspendLayout();
            SuspendLayout();
            // 
            // PatientIDBox
            // 
            PatientIDBox.Controls.Add(Query);
            PatientIDBox.Controls.Add(QueryPatientName);
            PatientIDBox.Controls.Add(label1);
            PatientIDBox.Location = new System.Drawing.Point(16, 8);
            PatientIDBox.Name = "PatientIDBox";
            PatientIDBox.Size = new System.Drawing.Size(624, 72);
            PatientIDBox.TabIndex = 0;
            PatientIDBox.TabStop = false;
            PatientIDBox.Text = "Query";
            // 
            // Query
            // 
            Query.Location = new System.Drawing.Point(496, 24);
            Query.Name = "Query";
            Query.Size = new System.Drawing.Size(104, 32);
            Query.TabIndex = 2;
            Query.Text = "Query";
            Query.Click += new System.EventHandler(Query_Click);
            // 
            // QueryPatientName
            // 
            QueryPatientName.BorderStyle = BorderStyle.FixedSingle;
            QueryPatientName.Location = new System.Drawing.Point(280, 30);
            QueryPatientName.Name = "QueryPatientName";
            QueryPatientName.Size = new System.Drawing.Size(192, 20);
            QueryPatientName.TabIndex = 1;
            QueryPatientName.Text = "*";
            // 
            // label1
            // 
            label1.AutoSize = true;
            label1.Location = new System.Drawing.Point(16, 32);
            label1.Name = "label1";
            label1.Size = new System.Drawing.Size(258, 16);
            label1.TabIndex = 0;
            label1.Text = "Enter Patient Name. (Leave Black or * if Unknown)";
            // 
            // Tree
            // 
            Tree.BorderStyle = BorderStyle.FixedSingle;
            Tree.ImageIndex = -1;
            Tree.Location = new System.Drawing.Point(16, 88);
            Tree.Name = "Tree";
            Tree.SelectedImageIndex = -1;
            Tree.Size = new System.Drawing.Size(624, 280);
            Tree.TabIndex = 1;
            Tree.AfterExpand += new TreeViewEventHandler(Tree_AfterExpand);
            // 
            // RetrieveBTN
            // 
            RetrieveBTN.Location = new System.Drawing.Point(144, 376);
            RetrieveBTN.Name = "RetrieveBTN";
            RetrieveBTN.Size = new System.Drawing.Size(112, 40);
            RetrieveBTN.TabIndex = 2;
            RetrieveBTN.Text = "Retrieve";
            RetrieveBTN.Click += new System.EventHandler(RetrieveBTN_Click);
            // 
            // ResetBTN
            // 
            ResetBTN.Location = new System.Drawing.Point(280, 376);
            ResetBTN.Name = "ResetBTN";
            ResetBTN.Size = new System.Drawing.Size(112, 40);
            ResetBTN.TabIndex = 3;
            ResetBTN.Text = "Reset";
            ResetBTN.Click += new System.EventHandler(ResetBTN_Click);
            // 
            // CloseBTN
            // 
            CloseBTN.Location = new System.Drawing.Point(416, 376);
            CloseBTN.Name = "CloseBTN";
            CloseBTN.Size = new System.Drawing.Size(112, 40);
            CloseBTN.TabIndex = 4;
            CloseBTN.Text = "Close";
            CloseBTN.Click += new System.EventHandler(CloseBTN_Click);
            // 
            // RetrieveDialogType
            // 
            AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            ClientSize = new System.Drawing.Size(656, 430);
            Controls.Add(CloseBTN);
            Controls.Add(ResetBTN);
            Controls.Add(RetrieveBTN);
            Controls.Add(Tree);
            Controls.Add(PatientIDBox);
            FormBorderStyle = FormBorderStyle.FixedSingle;
            MaximizeBox = false;
            Name = "RetrieveDialogType";
            Text = "RetrieveDialogType";
            PatientIDBox.ResumeLayout(false);
            ResumeLayout(false);

		}
		#endregion
		
		public void LoadPatient(OptionsBoxType o, DicomViewer v)
		{
			OptionsBox = o;
			viewer1 = v;
			ShowDialog();
		}

		private string GetDescription(DicomDataSet ds)
		{
			string s = ds.StudyDescription;
			if(string.IsNullOrEmpty(s))
			{
				s = StudyText;
			}

			if(ds[Keyword.StudyDate].ExistsWithValue)
			{
				s = $"{s} on {ds[Keyword.StudyDate].Value}";
			}
			return s;				  
		}
	
		// Query By Patient Name 
		private void Query_Click(object sender, EventArgs e)
		{
			query = new DicomQuery();
			DicomDataSet dataSet;			
			int index_r;
			string[] IDs = new string[5];

			Tree.Nodes.Clear();			
			PatientIDBox.Visible = false;
			
			query.Node = OptionsBox.RemoteNode.Text;
			query.Port = Convert.ToInt32(OptionsBox.RemotePort.Text);
			query.CallingAE = OptionsBox.CallingAE.Text;
			query.CalledAE = OptionsBox.RemoteAE.Text;
			
			if (OptionsBox.PatientRoot.Checked)
			{
				query.Level = QueryLevel.PATIENT;
				query.Root = QueryRoot.Patient;}
			else
			{
				query.Level = QueryLevel.STUDY;
				query.Root = QueryRoot.Study;
			}
			
			query.Name = QueryPatientName.Text;

			res = query.Find();
			TreeNode treeNode;
			
			for(index_r = 0; index_r <= res.Count -1; index_r ++)
			{
				dataSet = res[index_r];
				IDs[1] = dataSet.PatientID;
				if(OptionsBox.PatientRoot.Checked)
				{
					treeNode = Tree.Nodes.Add(dataSet.Name);
					IDs[0] = "1";
                    treeNode.Nodes.Add(StudyListRetrievingMessage);
				}
				else
                {
					treeNode = Tree.Nodes.Add(dataSet.Name + " / " + GetDescription(dataSet));
					IDs[0] = "2";
					IDs[2] = dataSet.StudyUID;
                    treeNode.Nodes.Add(SeriesRetrievingMessage);
				}
				treeNode.Tag = IDs.Clone();
				treeNode.Collapse();
			}
		}

		// Send out C-GET or C-MOVE Requests to Retrieve Images
		private void RetrieveBTN_Click(object sender, EventArgs e)
		{
			string[] Tags;
			int Tag0;			
			int i;
			DicomDataSetCollection dataSetCollection;
			DicomDataSet returnedStatus;
			TreeNode node = Tree.SelectedNode;

			Tags = (string[])node.Tag;				
			Tag0 = Convert.ToInt32(Tags[0].ToString());

			switch(Tag0)
			{
				case 1: // "PATIENT"
					SetPatientValues(Tags);
					break;
				case 2:	// "STUDY"
					query.PatientID = Tags[1];
					query.StudyUID = Tags[2];
					query.SeriesUID = "";
					query.InstanceUID = "";
					query.Level = QueryLevel.STUDY;
					break;
				case 3: // "SERIES"
					query.PatientID = Tags[1];
					query.StudyUID = Tags[2];
					query.SeriesUID = Tags[3];
					query.InstanceUID = "";
					query.Level = QueryLevel.SERIES;
					break;
				case 4: // INSTANCE
					query.PatientID = Tags[1];
					query.StudyUID = Tags[2];
					query.SeriesUID = Tags[3];
					query.InstanceUID = Tags[4];
					query.Level = QueryLevel.INSTANCE;
					break;
				default:
					SetPatientValues(Tags);
					break;
			}
				
			if(OptionsBox.CGET.Checked)
			{
				dataSetCollection = query.Get();
				for( i = 0; i < dataSetCollection.Count; i ++)
				{
                    viewer1.Images.Add(new DicomImage(dataSetCollection[i]));
				}
			}
			else if(OptionsBox.CMOVE.Checked)
			{
				query.Destination = OptionsBox.MoveDestination.Text;
				returnedStatus = query.Move();
				MessageBox.Show(MoveStatusText + returnedStatus[0x0000,0x0900].Value.ToString());
			}
			Close();
		}

		private void SetPatientValues(string[] tags)
        {
			query.PatientID = tags[1];
			query.StudyUID = "";
			query.SeriesUID = "";
			query.InstanceUID = "";
			query.Level = QueryLevel.PATIENT;
		}

		// Reset the Query TreeNode
		private void ResetBTN_Click(object sender, EventArgs e)
		{
			Tree.Nodes.Clear();
			PatientIDBox.Visible = true;
		}

		// Close the Query/Retrieve Dialog
		private void CloseBTN_Click(object sender, EventArgs e)
		{
			Close();
		}

		private void Tree_AfterExpand(object sender, TreeViewEventArgs e)
		{
			string[] Tags;
			int Tag0;
			string[] IDs = new string[6];
			int i;
			string s;
			int index_r;
			DicomDataSet r;
			TreeNode nd;

			Tags = (string[])e.Node.Tag;				
			Tag0 = Convert.ToInt32(Tags[0].ToString());

			for(i = 1; i <= Tag0; i++)
			{
				IDs[i] = Tags[i];
			}

			IDs[0] = (Tag0 + 1).ToString();
			
			switch(Tag0)
			{
				case 1: // "PATIENT"
					query.Level = QueryLevel.STUDY;
					query.PatientID = Tags[1];
					query.StudyUID = "";
					query.SeriesUID = "";
					query.InstanceUID = "";
					res = query.Find();                    
					e.Node.Nodes.Clear();

                    for (index_r = 0; index_r < res.Count; index_r++)
					{
						r = res[index_r];
						s = GetDescription(r);
						nd = e.Node.Nodes.Add(s);
						IDs[2] = r.StudyUID;
						nd.Tag = IDs.Clone();
						nd.Nodes.Add(SeriesRetrievingMessage);
						nd.Collapse();
					}
					break;
				case 2: // "STUDY"
					query.Level = QueryLevel.SERIES;
					query.PatientID = Tags[1];
					query.StudyUID = Tags[2];
					query.SeriesUID = "";
					query.InstanceUID = "";
					res = query.Find();
					e.Node.Nodes.Clear();

                    for (index_r = 0; index_r < res.Count; index_r++)
					{
						r = res[index_r];
						s = r.SeriesDescription;
						if (s == "")
							s = "**SERIES**";
						nd = e.Node.Nodes.Add(s);
						IDs[3] = r.SeriesUID;
						nd.Tag = IDs.Clone();
						nd.Nodes.Add(ImagesRetrievingMessage);
						nd.Collapse();
					}
					break;
				case 3: // "SERIES"
                    query.Level = QueryLevel.INSTANCE;
					query.PatientID = Tags[1];
					query.StudyUID = Tags[2];
					query.SeriesUID = Tags[3];
					query.InstanceUID = "";
					res = query.Find();

					e.Node.Nodes.Clear();
                    for (index_r = 0; index_r < res.Count; index_r++)
					{
	                    r = res[index_r];
		                s = r.InstanceUID;
			            nd = e.Node.Nodes.Add(s);
				        IDs[4] = r.InstanceUID;
						nd.Tag = IDs.Clone();
					}
					break;
				case -1: // case -1/-2/-3, Do nothing, already retrieved	
				case -2:
				case -3:
					break;
				default:
					MessageBox.Show(InvalidLevel);
					break;
			}
			Tags[0] = (-Tag0).ToString();
		}
	}
}
