﻿using System;
using System.Windows.Forms;

namespace DicomObjects_V8_Sample_Viewer
{
    public partial class OptionsBoxType : Form
    {
        public DicomObjects.DicomServer ServerOpt { get; set; }

        public OptionsBoxType()
        {
            InitializeComponent();
        }

        private void NewOptionsBox_Load(object sender, EventArgs e)
        {
			if(CallingAE.Text == "")
				CallingAE.Text = Environment.MachineName;
            
			if(MoveDestination.Text == "")
				MoveDestination.Text = Environment.MachineName;

            logLevelList.SelectedIndex = 0;
        }

        private void Port_Enter(object sender, EventArgs e)
        {
			ServerOpt.Unlisten(Convert.ToInt32(Port.Text));
        }

        private void Port_Leave(object sender, EventArgs e)
        {
			ServerOpt.Listen(Convert.ToInt32(Port.Text));
        }

        private void CMOVE_CheckedChanged(object sender, EventArgs e)
        {
			if(CMOVE.Checked)
			{
				MessageBox.Show(@"
You have requested use of a C-MOVE operation.  
Please note that this can ONLY work if the SCP has been set up to 'know' your AET title, and to associate it with your IP address and listening port.  
If the supplied simple server is running on the same machine, then this is OK, as it associates LOCAL = localhost/11112, but if using another server, then this information MUST be set up on that server, as the DICOM C-MOVE protocol allows no method of specifying the destination other than the AE title, which for you currently is '" + MoveDestination.Text + "'\n\rNote that you may also need to change your listening port (by default 11112) to the value known to the server");
			}
        }

        private void StartLoggingBTN_Click(object sender, EventArgs e)
        {
            int logLevel = 0x7;
            switch (logLevelList.SelectedIndex)
            {
                case 0:
                    logLevel = 0x7;
                    break;
                case 1:
                    logLevel = 0x3F;
                    break;
                case 2:
                    logLevel = 0x3FF;
                    break;                
            }
			DicomObjects.DicomGlobal.LogToFile(LogPathText.Text, logLevel);
        }

        private void StopLoggingBTN_Click(object sender, EventArgs e)
        {
			DicomObjects.DicomGlobal.LogToFileStop();
        }
    }
}
