﻿using DicomObjects.Enums;
using System;
using System.Drawing;
using System.Windows.Forms;
using DicomObjects;

namespace DicomObjects_V8_Sample_Viewer
{
    public partial class LabelFormType : Form
    {
        internal ColorDialog colorDialog = new ColorDialog();
        internal FontDialog fontDialog = new FontDialog();

        public LabelFormType()
        {
            InitializeComponent();
        }

        internal LabelType LabelType
        {
            get
            {
                if (Angle.Checked) // handled as pair of lines
                    return LabelType.Line;
                else
                    return Utilities.GroupBoxToEnum<LabelType>(LabelTypeGroup);
            }
        }

        internal ScaleMode ScaleMode
        {
            get { return Utilities.GroupBoxToEnum<ScaleMode>(Tied); }
        }

        internal DicomLabel NewLabel(PointF InitialPosition)
        {
            var CurrentLabel = new DicomLabel()
            {
                ScaleMode = ScaleMode.Output, // always output during drawing - rescaled later
                LabelType = LabelType,
                TextBrush = new SolidBrush(ForeColour.BackColor),
                Font = fontDialog.Font,
                Pen = new Pen(ForeColour.BackColor, Convert.ToInt16(LineWidth.Text)),
                ShowTextBox = true,
                Brush = Transparent.Checked ? Brushes.Transparent : new SolidBrush(BackColour.BackColor),
                Left = InitialPosition.X,
                Top = InitialPosition.Y,
            };

            CurrentLabel.AddPoint(InitialPosition);
            return CurrentLabel;
        }

        private void ForeColour_Click(object sender, EventArgs e)
        {
            colorDialog.Color = ForeColour.BackColor;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                ForeColour.BackColor = colorDialog.Color;
            }
        }

        private void BackColour_Click(object sender, EventArgs e)
        {
            colorDialog.Color = BackColour.BackColor;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                BackColour.BackColor = colorDialog.Color;
            }
        }

        private void FontDisplay_DoubleClick(object sender, EventArgs e)
        {
            fontDialog.Font = FontDisplay.Font;
            if (fontDialog.ShowDialog() == DialogResult.OK)
            {
                FontDisplay.Text = fontDialog.Font.Name;
                FontDisplay.Font = fontDialog.Font;
            }
        }

        internal bool IsAngle()
        {
            return Angle.Checked;
        }

        private void OK_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
