﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;

namespace Simple3DViewer
{
    public class VolumeRenderingPreset
    {
        public string Name { get; set; }
        public List<ScalarOpacityPoint> OpacityPoints { get; set; } = new List<ScalarOpacityPoint>();
        public List<ColorTransferPoint> ColorPoints { get; set; } = new List<ColorTransferPoint>();

        public float MinValue => ColorPoints.Count > 0 ? ColorPoints.Min(p => p.Value) : 0;
        public float MaxValue => ColorPoints.Count > 0 ? ColorPoints.Max(p => p.Value) : 1;
    }

    public class ScalarOpacityPoint
    {
        public float Value { get; set; }
        public float Opacity { get; set; }
    }

    public class ColorTransferPoint
    {
        public float Value { get; set; }
        public float R { get; set; }
        public float G { get; set; }
        public float B { get; set; }

        public Color ToColor(float opacity = 1f)
        {
            return Color.FromArgb(
                (int)(opacity * 255),
                (int)(R * 255),
                (int)(G * 255),
                (int)(B * 255)
            );
        }
    }
}
