﻿using System;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using DicomObjects;

namespace DemoSRViewer
{
    public partial class Form1 : Form
    {
        DicomDataSet SR;
        public Form1()
        {
            InitializeComponent();
        }

        string[] SequencesToRead = { "Measurement Group" };
        private void Load_Dicom_SR_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.ShowDialog();
            if (!string.IsNullOrEmpty(ofd.FileName))
            {
                progressBar1.Visible = true;
                DicomDataSetCollection ds = new DicomDataSetCollection();
                SR = new DicomDataSet(ofd.FileName);
                string content = ReadSRContent(SR);
                WriteToTempFile(content);
                webBrowser1.Navigate(Application.StartupPath + "\\temp.html");
                progressBar1.Visible = false;
            }
        }

        private void WriteToTempFile(string content)
        {
            string fileName = Path.Combine(Application.StartupPath,"temp.html");
            File.WriteAllText(fileName, content);
        }

        private string ReadSRContent(DicomDataSet SR)
        {
            string result, title;
            title = ReadSRTitle(SR);
            result = "<center><h2><b><u>DicomObjects Sample SR</b></u></h2></center>";
            result = result + "<br>";
            result = result + "<center><h2><font color = blue>" + title + "</font></h2></center>";
            result = result + "<hr>";
            result = result + "<br>";

            // =====================  Basic Patient Information  =====================
            // Patient Name
            if (SR[0x0010, 0x0010].Exists)
            {
                string patientName = SR[0x0010, 0x0010].Value + "";
                AddBasicTag(ref result, "Patient Name", patientName);
            }

            // Patient ID
            if (SR[0x0010, 0x0020].Exists)
            {
                string patientID = SR[0x0010, 0x0020].Value + "";
                AddBasicTag(ref result, "Patient ID", patientID);
            }

            //' Date of Birth
            if (SR[0x0010, 0x0030].Exists)
            {
                string patientDOB = SR[0x0010, 0x1030].Value + "";
                AddBasicTag(ref result, "Patient Date of Birth", patientDOB);
            }

            //' Sex
            if (SR[0x0010, 0x0040].Exists)
            {
                string patientSex = SR[0x0010, 0x0040].Value + "";
                AddBasicTag(ref result, "Patient Sex", patientSex);
            }

            //' Complete Flag
            if (SR[0x0040, 0xA491].Exists)
            {
                string completeFlag = SR[0x0040, 0xA491].Value + "";
                AddBasicTag(ref result, "Complete Flag", completeFlag);
            }

            //' Verification Flag
            if (SR[0x0040, 0xA493].Exists)
            {
                string verificationFlag = SR[0x0040, 0xA493].Value + "";
                AddBasicTag(ref result, "Verification Flag", verificationFlag);
            }

            result = result + "<br>" + "<hr>" + "<br>";

            //'===============  Get Entire Content Sequence  ===============

            DicomDataSetCollection cs = (DicomDataSetCollection)SR[0x0040, 0xA730].Value;

            foreach (DicomDataSet i in cs)
            {
                //' Read Each Individual Sequence Item
                ReadSRContentItem(i, ref result, 1, false);     // false to not read sequences by default
            }
            return (result);
        }

        private void ReadSRContentItem(DicomDataSet SR, ref string result, int level, bool ReadSequence)
        {
            bool readSQ = ReadSequence;
            //' Read Container Item
            if (SR[0x0040, 0xA040].Exists)
            {
                if ((string)SR[0x0040, 0xA040].Value == "CONTAINER" || readSQ == true)
                {
                    DicomDataSetCollection cds;
                    cds = (DicomDataSetCollection)SR[0x0040, 0xA043].Value;
                    string cName = cds[0][0x0008, 0x0104].Value + "";

                    if(SequencesToRead.Contains(cName))
                        readSQ = true;                              //  Identifying sequence to be read

                    if(!readSQ)                                     // avoid repeating cName to output html
                        AddContainerTag(ref result, cName, level);

                    if (SR[0x0040, 0xA730].Exists)
                    {
                        level++;
                        DicomDataSetCollection s = (DicomDataSetCollection)SR[0x0040, 0xA730].Value;
                        for (int i = 0; i < s.Count; i++)
                        {
                            ReadSRContentItem(s[i], ref result, level, readSQ);
                        }
                    }
                }
            }

            //' read Code Item
            if (SR[0x0040, 0xA040].Exists)
            {
                if ((string)SR[0x0040, 0xA040].Value == "CODE")
                {
                    DicomDataSetCollection ds1 = (DicomDataSetCollection)SR[0x0040, 0xA043].Value;                   //' Concept Name Code Sequence           
                    string codeName = (string)ds1[0][0x0008, 0x0104].Value;
                    DicomDataSetCollection ds2 = (DicomDataSetCollection)SR[0x0040, 0xA168].Value;                            //' Concept Code Sequence
                    string codeValue = (string)ds2[0][0x0008, 0x0100].Value;
                    string codingSchemeDesignator = (string)ds2[0][0x0008, 0x0102].Value;
                    string codeMeaning = (string)ds2[0][0x0008, 0x0104].Value;
                    AddContainerTag(ref result, codeName + " : " + codeMeaning + " (" + codeValue + "," + codingSchemeDesignator + ")", level);
                }
            }

            //' read Text Item
            if ((string)SR[0x0040, 0xA040].Value == "TEXT")
            {
                DicomDataSetCollection dx2 = (DicomDataSetCollection)SR[0x0040, 0xA043].Value;
                string codeMean = (string)dx2[0][0x0008, 0x0104].Value;
                codeMean = "<b><u>" + codeMean + "</u></b>";
                string textValue = SR[0x0040, 0xA160].Value + "";
                AddContainerTag(ref result, codeMean + " : " + textValue, level);
            }

            //' read Object (Image, Waveform,etc. Composite Object) Item
            if (SR[0x0040, 0xA040].Exists)
            {
                if ((string)SR[0x0040, 0xA040].Value == "IMAGE")
                {
                    DicomDataSetCollection refds = (DicomDataSetCollection)SR[0x0008, 0x1199].Value;
                    string refInsUI;                                      //' Referenced Instance UID
                    refInsUI = (string)refds[0][0x0008, 0x1155].Value + "";
                    DicomDataSetCollection ids = (DicomDataSetCollection)SR[0x0040, 0xA043].Value;
                    string cm = (string)ids[0][0x0008, 0x0104].Value + "";
                    cm = "<b><u>" + cm + "</u></b>";
                    AddContainerTag(ref result, cm + " : " + refInsUI, level);
                }
            }

            //' read Other Text Format Item
            if (SR[0x0040, 0xA040].Exists)
            {
                if (((string)SR[0x0040, 0xA040].Value == "DateTime") || ((string)SR[0x0040, 0xA040].Value == "Date") ||
                    ((string)SR[0x0040, 0xA040].Value == "Time") || ((string)SR[0x0040, 0xA040].Value == "PNAME"))
                {
                    DicomDataSetCollection ds3 = (DicomDataSetCollection)SR[0x0040, 0xA043].Value;
                    string codeName2;
                    string codeMeaning2;
                    codeName2 = ds3[0][0x0008, 0x0104].Value + "";
                    codeMeaning2 = SR[0x0040, 0xA123].Value + "";
                    AddContainerTag(ref result, codeName2 + " : " + codeMeaning2, level);
                }
            }
            //' read Num Format Item
            if (SR[0x0040, 0xA040].Exists)
            {
                if ((string)SR[0x0040, 0xA040].Value == "NUM")
                {
                    DicomDataSetCollection ds1 = (DicomDataSetCollection)SR[0x0040, 0xA043].Value;                                                  //' Concept Name Code Sequence           
                    string codeName = (string)ds1[0][0x0008, 0x0104].Value;
                    
                    DicomDataSetCollection ds2 = (DicomDataSetCollection)SR[0x0040, 0xA300].Value;
                    DicomDataSetCollection MeasurementUnitsCodeSQ = (DicomDataSetCollection)ds2[0][0x0040, 0x08EA].Value;                            //' Concept Code Sequence
                    if (MeasurementUnitsCodeSQ != null)
                    {
                        string value = string.Join(", ", (string[])ds2[0][0x0040, 0xA30A].Value);
                        string codeName2 = (string)MeasurementUnitsCodeSQ[0][0x0008, 0x0104].Value;
                        AddContainerTag(ref result, codeName + " : " + value + codeName2, level);
                    }
                }
            }
        }

        private void AddContainerTag(ref string s, string addin, int level)
        {
            switch (level)
            {
                case 1:
                    s = s + "<font size = 3 face = Arial color = gray>" + "<b>" + addin + "</b>" + "</font><br>";
                    break;
                default:
                    s = s + "<ul><p><font size = 2 face = Arial>" + "<b>" + addin + "</b>" + "</font></p></ul>";
                    break;
                //case 3:
                //    s = s + "<ul><ul><font size = 2 face = Arial>" + "<b>" + addin + "</b>" + "</font></ul></ul>";
                //    s = s + "<ul><ul><font size = 2 face = Arial>" + "<b>" + addin + "</b>" + "</font></ul></ul>";
                //    break;
                //case 4:
                //    s = s + "<ul><ul><ul><font size = 2 face = Arial>" + "<b>" + addin + "</b>" + "</font></ul></ul></ul>";
                //    break;

                //case 5:
                //    s = s + "<ul><ul><ul><ul><font size = 2 face = Arial>" + "<b>" + addin + "</b>" + "</font></ul></ul></ul></ul>";
                //    s = s + "<ul><ul><ul><ul><ul><font size = 2 face = Arial>" + "<b>" + addin + "</b>" + "</font></ul></ul></ul></ul></ul>";
                //    break;
            }
        }

        void AddBasicTag(ref string s, string title, string addin)
        {
            s = s + "<font size = 2 face = Arial>" + title + ": " + addin + "</font>" + "<br>";
        }
        string ReadSRTitle(DicomDataSet SR)
        {
            DicomDataSetCollection dsc = (DicomDataSetCollection) SR[0x0040, 0xA043].Value;
            return ((string)dsc[0][0x0008, 0x0104].Value + " ");
        }
    }
}
