using System;
using System.Windows.Forms;
using DicomObjects;

namespace DICOMDir
{
    public partial class Form1 : Form
    {      
        public Form1()
        {
            InitializeComponent();
        }

        private void LoadDIRBTN_Click(object sender, EventArgs e)
        {
            treeView1.Nodes.Clear(); 
            DicomObjects.DicomDataSet DicomDIR;
            string rootpath;
            openFileDialog1.FileName = "";
            openFileDialog1.ShowDialog();

            if (openFileDialog1.FileName != "")
            {   
                DicomDIR = new DicomDataSet(openFileDialog1.FileName);
                rootpath = openFileDialog1.FileName.Substring(0, openFileDialog1.FileName.Length - 9);
                
                foreach (DicomDataSet Patient in DicomDIR.Children) // Patient Level
                {
                    int ImageCount = 0;
                    TreeNode patientNode = treeView1.Nodes.Add(Patient.Name);
                    patientNode.Name = "PatientLevelNode";
                    patientNode.Tag = "PATIENT";

                    foreach (DicomDataSet Study in Patient.Children) // Study Level
                    {
                        string stDes = Study.StudyDescription;
                        stDes = (Study.StudyDescription!="" ? Study.StudyDescription : "Study");
                        TreeNode studyNode = patientNode.Nodes.Add("StudyLevelNode", stDes);
                        studyNode.Tag = "STUDY";
                        foreach (DicomDataSet Series in Study.Children) // Series Level
                        {
                            string seDes = Series.StudyDescription;
                            seDes = (Series.SeriesDescription != "" ? Series.SeriesDescription : "Series");
                            TreeNode seriesNode = studyNode.Nodes.Add("SeriesLevelNode", seDes);
                            seriesNode.Tag = "Series";
                            foreach (DicomDataSet Image in Series.Children) // Image Level
                            { 
                                string[] pathComponents = new string[7];
                                string ImageFilePath = rootpath;
                                pathComponents = (string[])Image[0x4, 0x1500].Value;
                                for (int level = 0; level < pathComponents.GetLength(0); level ++ )
                                {
                                    if (pathComponents[level] != "")
                                        ImageFilePath = ImageFilePath + "\\" + pathComponents[level];
                                }
                                seriesNode.Nodes.Add("SeriesLevelNode", ImageFilePath);
                                ImageCount++;
                            }
                        }
                    }
                    patientNode.Text = patientNode.Text + " ( " + ImageCount.ToString() + " Image(s) )";
                }
            }
        }

    }
}