Attribute VB_Name = "Utils"

Public Const Pi As Double = 3.14159265358979

Sub AppendAttributes(ByRef list, prefix, ByRef ob As Object)
    Dim at As DicomAttribute
    Dim s As DicomDataSets
    Dim i As Integer
    Dim v As Variant
    Dim ele As Variant
    
    For Each at In ob
        list = list & prefix & "(" & hex4(at.Group) & "," & hex4(at.Element) & ") : "
        list = list & Left(at.Description & Space(30), 30) & ": "
        If (at.Group = &H7FE0) Then    ' pixel data
            list = list & "Pixel data" & vbCrLf
        ElseIf (VarType(at.Value) = 9) Then    ' i.e. a sequence
            Set s = at.Value
            list = list & "Sequence of " & s.Count & " items:" & vbCrLf
            For i = 1 To s.Count
                list = list & prefix & ">----S" & i & "-----------" & vbCrLf
                AppendAttributes list, prefix & ">", s(i).Attributes
                list = list & prefix & ">-----E" & i & "----------" & vbCrLf
            Next
            list = list & prefix & ">==============================" & vbCrLf
        Else
            v = at.Value    ' could be variant or array
            If (VarType(v) > 8192) Then    ' i.e. an array
                list = list & "Multiple values :" & vbCrLf & "              "
                If UBound(v, 1) > 32 Then
                    list = list & "Array of " & UBound(v, 1) & " elements"
                Else
                    For i = LBound(v, 1) To UBound(v, 1)
                        list = list & v(i)
                        If i <> UBound(v, 1) Then list = list & " : "
                    Next

                End If
                list = list & vbCrLf
            Else
                list = list & v & vbCrLf
            End If
        End If
    Next
End Sub

Function hex4(ByVal v As Long) As String
    hex4 = Right("000" & Hex(v), 4)
End Function

Function min(a, b) As Integer
    If a > b Then
        min = b
    Else
        min = a
    End If
End Function

Function max(a, b) As Integer
    If a < b Then
        max = b
    Else
        max = a
    End If
End Function

Function GetSamplePath(ProjectsFolder As String, ImageFolder As String) As String

    'Get current
    Dim p As String
    p = App.path
    
    While (Not EndsWith(p, ProjectsFolder)) And (Not p = "")
        p = GetParentFolder(p)
    Wend
    If p = "" Then
        GetSamplePath = ""
    Else
        GetSamplePath = GetParentFolder(p) + "\" + ImageFolder
    End If

End Function

Function GetParentFolder(path As String) As String

    Dim pos As Integer
    pos = InStrRev(path, "\")
    If pos > 0 Then
        GetParentFolder = Left$(path, pos - 1)
    Else
        GetParentFolder = ""
    End If
    
End Function

Function EndsWith(target As String, query As String) As Boolean

    Dim ql As Long
    ql = Len(query)
    
    If ql > Len(target) Then
        EndsWith = False
    ElseIf StrComp(query, Right$(target, ql)) = 0 Then
        EndsWith = True
    End If
    
End Function

Public Function ArcTan2(y As Double, x As Double) As Double

  If x > 0 Then
    ArcTan2 = Atn(y / x)
  ElseIf x < 0 Then
    ArcTan2 = Sgn(y) * (Pi - Atn(Abs(y / x)))
  ElseIf y = 0 Then
    ArcTan2 = 0
  Else
    ArcTan2 = Sgn(y) * Pi / 2
  End If

End Function
