VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}#1.1#0"; "ieframe.dll"
Begin VB.Form SR_Reader 
   Caption         =   "Demo SR viewer"
   ClientHeight    =   10020
   ClientLeft      =   195
   ClientTop       =   510
   ClientWidth     =   19935
   LinkTopic       =   "Form1"
   ScaleHeight     =   10020
   ScaleWidth      =   19935
   StartUpPosition =   3  'Windows Default
   Begin SHDocVwCtl.WebBrowser WebBrowser1 
      Height          =   9855
      Left            =   2400
      TabIndex        =   1
      Top             =   120
      Width           =   17535
      ExtentX         =   30930
      ExtentY         =   17383
      ViewMode        =   0
      Offline         =   0
      Silent          =   0
      RegisterAsBrowser=   0
      RegisterAsDropTarget=   1
      AutoArrange     =   0   'False
      NoClientEdge    =   0   'False
      AlignLeft       =   0   'False
      NoWebView       =   0   'False
      HideFileNames   =   0   'False
      SingleClick     =   0   'False
      SingleSelection =   0   'False
      NoFolders       =   0   'False
      Transparent     =   0   'False
      ViewID          =   "{0057D0E0-3573-11CF-AE69-08002B2E1262}"
      Location        =   ""
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   840
      Top             =   6840
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Load DicomSR"
      Height          =   1095
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   1935
   End
End
Attribute VB_Name = "SR_Reader"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim SR As DicomDataSet

Private Sub Command1_Click()
    CommonDialog1.InitDir = GetSamplePath("SampleProjects", "SampleImages\2D")
    CommonDialog1.ShowOpen
    If CommonDialog1.fileName <> "" Then
        Dim ds As New DicomDataSets
        Dim content As String
        Set SR = New DicomDataSet
        Set SR = ds.ReadFile(CommonDialog1.fileName)
        content = ReadSRContent(SR)
        WriteToTempFile content
        SR_Reader.WebBrowser1.Navigate App.path & "\" & "temp.html"
    End If
End Sub

Sub WriteToTempFile(content As String)
    Dim fileName As String
    fileName = App.path & "\" & "temp.html"
    Dim i As Integer
    i = FreeFile
    Open fileName For Output As #i
    Print #i, content
    Close #i
End Sub

Sub AddBasicTag(s As String, title As String, addin As String)
   s = s & "<font size = 2 face = Arial>" & title & ": " & addin & "</font>"
   s = s & "<br>"
End Sub

Sub AddContainerTag(s As String, addin As String, level As Integer)

   If level = 1 Then ' 1st level heading
   s = s & "<font size = 3 face = Arial color = gray>" & "<b>" & addin & "</b>" & "</font>"
   s = s & "<br>"
   End If
   
   If level = 2 Then ' 2nd level heading
   s = s & "<ul><p><font size = 2 face = Arial>" & "<b>" & addin & "</b>" & "</font></p></ul>"
   End If
   
   If level = 3 Then ' 3rd level heading
   s = s & "<ul><ul><font size = 2 face = Arial>" & "<b>" & addin & "</b>" & "</font></ul></ul>"
   End If
   
   If level = 3 Then
   s = s & "<ul><ul><font size = 2 face = Arial>" & "<b>" & addin & "</b>" & "</font></ul></ul>"
   End If
   
   If level = 4 Then
   s = s & "<ul><ul><ul><font size = 2 face = Arial>" & "<b>" & addin & "</b>" & "</font></ul></ul></ul>"
   End If
   
   If level = 5 Then
   s = s & "<ul><ul><ul><ul><font size = 2 face = Arial>" & "<b>" & addin & "</b>" & "</font></ul></ul></ul></ul>"
   End If
   
   If level > 5 Then
   s = s & "<ul><ul><ul><ul><ul><font size = 2 face = Arial>" & "<b>" & addin & "</b>" & "</font></ul></ul></ul></ul></ul>"
   End If
End Sub

Sub ReadSRContentItem(SR As DicomDataSet, result As String, level As Integer)
    ' Read Container Item
    If SR.Attributes(&H40, &HA040).Exists Then
       If (SR.Attributes(&H40, &HA040).Value = "CONTAINER") Then
         Dim cds As New DicomDataSets
         Set cds = SR.Attributes(&H40, &HA043).Value
         Dim cName As String
         cName = cds(1).Attributes(&H8, &H104).Value & ""
         AddContainerTag result, cName, level
         
         If SR.Attributes(&H40, &HA730).Exists Then
             level = level + 1
             Dim s As New DicomDataSets
             Set s = SR.Attributes(&H40, &HA730).Value
             Dim i As Integer
             For i = 1 To s.Count
                ReadSRContentItem s(i), result, level
             Next
         End If
       End If
    End If
    
    ' read Code Item
    If SR.Attributes(&H40, &HA040).Exists Then
       If (SR.Attributes(&H40, &HA040).Value = "CODE") Then
           
           Dim ds1 As New DicomDataSets
           Set ds1 = SR.Attributes(&H40, &HA043).Value ' Concept Name Code Sequence
           
           Dim codeName As String
           codeName = ds1(1).Attributes(&H8, &H104).Value
           
           Dim ds2 As New DicomDataSets
           Set ds2 = SR.Attributes(&H40, &HA168).Value ' Concept Code Sequence
           Dim codeMeaning As String
           codeMeaning = ds2(1).Attributes(&H8, &H104).Value
           AddContainerTag result, (codeName & " : " & codeMeaning), level
       End If
    End If
    
    ' read Text Item
    If (SR.Attributes(&H40, &HA040).Value = "TEXT") Then
        Dim dx2 As New DicomDataSets
        Set dx2 = SR.Attributes(&H40, &HA043).Value
        Dim codeMean As String
        codeMean = dx2(1).Attributes(&H8, &H104).Value
        codeMean = "<b><u>" & codeMean & "</u></b>"
        Dim textValue As String
        textValue = SR.Attributes(&H40, &HA160).Value & ""
        
        AddContainerTag result, codeMean & " : " & textValue, level
    End If
    
    ' read Object (Image, Waveform,etc. Composite Object) Item
    If SR.Attributes(&H40, &HA040).Exists Then
       If (SR.Attributes(&H40, &HA040).Value = "IMAGE") Then
           Dim refds As New DicomDataSets
           Set refds = SR.Attributes(&H8, &H1199).Value
           Dim refInsUI As String   ' Referenced Instance UID
           refInsUI = refds(1).Attributes(&H8, &H1155).Value & ""
           Dim ids As New DicomDataSets
           Set ids = SR.Attributes(&H40, &HA043).Value
           Dim cm As String
           cm = ids(1).Attributes(&H8, &H104).Value & ""
           cm = "<b><u>" & cm & "</u></b>"
           AddContainerTag result, cm & " : " & refInsUI, level
       End If
    End If
    
    ' read Other Text Format Item
    If SR.Attributes(&H40, &HA040).Exists Then
       If (SR.Attributes(&H40, &HA040).Value = "DateTime") _
       Or (SR.Attributes(&H40, &HA040).Value = "Date") _
       Or (SR.Attributes(&H40, &HA040).Value = "Time") _
       Or (SR.Attributes(&H40, &HA040).Value = "PNAME") Then
       Dim ds3 As New DicomDataSets
       Set ds3 = SR.Attributes(&H40, &HA043).Value
       Dim codeName2 As String
       Dim codeMeaning2 As String
       codeName2 = ds3(1).Attributes(&H8, &H104).Value & ""
       codeMeaning2 = SR.Attributes(&H40, &HA123).Value & ""
       AddContainerTag result, (codeName2 & " : " & codeMeaning2), level
       End If
    End If
End Sub

Function ReadSRTitle(SR As DicomDataSet) As String
    Dim dss As DicomDataSets
    Set dss = SR.Attributes(&H40, &HA043).Value ' no checking of the existence
    
    ReadSRTitle = dss(1).Attributes(&H8, &H104).Value & ""
End Function

Function ReadSRContent(SR As DicomDataSet) As String
    Dim result As String
    Dim title As String
    
    title = ReadSRTitle(SR)
    
    result = "<center><h2><b><u>DicomObjects Sample SR</b></u></h2></center>"
    result = result & "<br>"
    result = result & "<center><h2><font color = blue>" & title & "</font></h2></center>"
    result = result & "<hr>"
    result = result & "<br>"
    
    '=====================  Basic Patient Information  =====================
    
    ' Patient Name
    If SR.Attributes(&H10, &H10).Exists Then
        Dim patientName As String
        patientName = SR.Attributes(&H10, &H10).Value & ""
        AddBasicTag result, "Patient Name", patientName
    End If
            
    ' Patient ID
    If SR.Attributes(&H10, &H20).Exists Then
        Dim patientID As String
        patientID = SR.Attributes(&H10, &H20).Value & ""
        AddBasicTag result, "Patient ID", patientID
    End If
    
    ' Date of Birth
    If SR.Attributes(&H10, &H30).Exists = True Then
        Dim patientDOB As String
        patientDOB = SR.Attributes(&H10, &H30).Value & ""
        AddBasicTag result, "Patient Date of Birth", patientDOB
    End If
    
    ' Sex
    If SR.Attributes(&H10, &H40).Exists = True Then
        Dim patientSex As String
        patientSex = SR.Attributes(&H10, &H40).Value & ""
        AddBasicTag result, "Patient Sex", patientSex
    End If
    
    ' Complete Flag
    If SR.Attributes(&H40, &HA491).Exists = True Then
        Dim completeFlag As String
        completeFlag = SR.Attributes(&H40, &HA491).Value & ""
        AddBasicTag result, "Complete Flag", completeFlag
    End If
    
    ' Verification Flag
    If SR.Attributes(&H40, &HA493).Exists = True Then
        Dim verificationFlag As String
        verificationFlag = SR.Attributes(&H40, &HA493).Value & ""
        AddBasicTag result, "Verification Flag", verificationFlag
    End If
    
    result = result & "<br>"
    result = result & "<hr>"
    result = result & "<br>"
     
    '===============  Get Entire Content Sequence  ===============

    Dim cs As New DicomDataSets
    Set cs = SR.Attributes(&H40, &HA730).Value
    
    Dim i As Integer
    
    For i = 1 To cs.Count   ' Read Each Individual Sequence Item
        ReadSRContentItem cs(i), result, 1
    Next i
    
    ReadSRContent = result
End Function

Private Sub Form_Load()
    Dim g As New DicomGlobal
    Me.Caption = Me.Caption & " DicomObjects v" & g.Version
    WebBrowser1.Navigate "www.medicalconnections.co.uk"
End Sub
