Attribute VB_Name = "Module1"
Option Explicit

Function GetSamplePath(ProjectsFolder As String, ImageFolder As String) As String

    'Get current
    Dim p As String
    p = App.path
    
    While (Not EndsWith(p, ProjectsFolder)) And (Not p = "")
        p = GetParentFolder(p)
    Wend
    If p = "" Then
        GetSamplePath = ""
    Else
        GetSamplePath = GetParentFolder(p) + "\" + ImageFolder
    End If

End Function

Function GetParentFolder(path As String) As String

    Dim pos As Integer
    pos = InStrRev(path, "\")
    If pos > 0 Then
        GetParentFolder = Left$(path, pos - 1)
    Else
        GetParentFolder = ""
    End If
    
End Function

Function EndsWith(target As String, query As String) As Boolean

    Dim ql As Long
    ql = Len(query)
    
    If ql > Len(target) Then
        EndsWith = False
    ElseIf StrComp(query, Right$(target, ql)) = 0 Then
        EndsWith = True
    End If
    
End Function
