VERSION 5.00
Object = "{D1C00008-F528-4513-A681-386B6F2F74E1}#8.0#0"; "DicomObjects.8.32.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form SR_Form 
   Caption         =   "DicomObjects SR Creator VB Example"
   ClientHeight    =   8532
   ClientLeft      =   60
   ClientTop       =   348
   ClientWidth     =   9312
   LinkTopic       =   "Form1"
   ScaleHeight     =   8532
   ScaleWidth      =   9312
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox Text1 
      Appearance      =   0  'Flat
      Enabled         =   0   'False
      Height          =   2655
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   11
      Top             =   5640
      Width           =   4095
   End
   Begin VB.TextBox Reporter 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   120
      TabIndex        =   9
      Text            =   "Objects^DICOM"
      Top             =   4920
      Width           =   4095
   End
   Begin VB.TextBox ConclusionText 
      Appearance      =   0  'Flat
      Height          =   2200
      Left            =   4560
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   6
      Text            =   "SRCreator.frx":0000
      Top             =   6120
      Width           =   4455
   End
   Begin VB.TextBox FindingsText 
      Appearance      =   0  'Flat
      Height          =   2200
      Left            =   4560
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      Text            =   "SRCreator.frx":0030
      Top             =   3360
      Width           =   4455
   End
   Begin VB.TextBox HistoryText 
      Appearance      =   0  'Flat
      Height          =   2200
      Left            =   4560
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   4
      Text            =   "SRCreator.frx":0078
      Top             =   480
      Width           =   4455
   End
   Begin VB.CommandButton CreateReport 
      Caption         =   "Create Report"
      Height          =   615
      Left            =   2280
      TabIndex        =   2
      Top             =   3960
      Width           =   1935
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   8760
      Top             =   5640
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton LoadImage 
      Caption         =   "Load Image"
      Height          =   615
      Left            =   120
      TabIndex        =   1
      Top             =   3960
      Width           =   1935
   End
   Begin DicomObjects8.DicomViewer Viewer 
      Height          =   3495
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   4095
      _Version        =   524288
      _ExtentX        =   7223
      _ExtentY        =   6165
      _StockProps     =   35
      BackColor       =   0
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Attributes in SR"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   120
      TabIndex        =   12
      Top             =   5400
      Width           =   1350
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Reporter"
      Height          =   195
      Left            =   120
      TabIndex        =   10
      Top             =   4680
      Width           =   615
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Findings"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   4560
      TabIndex        =   8
      Top             =   3120
      Width           =   720
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Conclusion"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   4560
      TabIndex        =   7
      Top             =   5880
      Width           =   945
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "History"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   4560
      TabIndex        =   3
      Top             =   240
      Width           =   600
   End
End
Attribute VB_Name = "SR_Form"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub CreateReport_Click()
    Dim att As DicomAttribute
    Dim d As New DicomDataSet
    Dim im As DicomImage            ' the image on which the report is based
    Dim g As New DicomGlobal
    Set im = Viewer.CurrentImage
    Dim nullSequence As New DicomDataSets
    Dim history As DicomDataSet, findings As DicomDataSet, conclusions As DicomDataSet
    Dim ImageRef As DicomDataSet
    Dim verifier As DicomDataSet, verifiers As DicomDataSets
    
    'Check all images are part of the same study
    ' (It is possible to reference many studies, but that is beyond the scope of the simple demo)
    'This check also ensures that they belong to the same patient!
    
    If Viewer.Images.Count = 0 Then
        MsgBox "Must have at least one referenced image for this example"
        Exit Sub
    End If
    
    StudyUID = Viewer.Images(1).StudyUID
    For Each im In Viewer.Images
        If im.StudyUID <> StudyUID Then
            MsgBox "For this example, all images must be part of the same study"
            Exit Sub
        End If
    Next
           
    Set im = Viewer.Images(1)
    
    d.Name = im.Name
    d.PatientID = im.PatientID
    d.Sex = im.Sex
    d.DateOfBirth = im.DateOfBirth
    
    ' common details from image
    List = Array(&H20, &HD, &H8, &H20, &H8, &H30, &H8, &H50, &H8, &H90, &H20, &H10, &H8, &H1030)
    
    For i = 0 To UBound(List, 1) Step 2
        d.Attributes.Add List(i), List(i + 1), im.Attributes(List(i), List(i + 1))
    Next
    
    'SR sepecific stuff
    d.SeriesUID = g.NewUID
    d.Attributes.Add 8, &H60, "SR"                  ' Modality
    d.SOPClass = doSOP_BasicTextSR
    d.InstanceUID = g.NewUID
    d.Attributes.Add &H20, &H11, 1                  ' Series Number
    d.Attributes.Add &H20, &H13, 1                  ' Instance Number
    d.Attributes.Add 8, &H70, "Manufacturer Name"   ' Manufacturer
    d.Attributes.Add 8, &H23, Now                   ' Content Date
    d.Attributes.Add 8, &H33, Now                   ' Content Time
    
    d.Attributes.Add 8, &H1111, nullSequence        ' Referenced Study Component Sequence
    d.Attributes.Add &H40, &HA040, "CONTAINER"      ' Value Type
    d.Attributes.Add &H40, &HA050, "SEPARATE"       ' Continuity of Content
    d.Attributes.Add &H40, &HA372, nullSequence     ' Performed Procedure Code Sequence
    d.Attributes.Add &H40, &HA491, "COMPLETE"       ' Completion Flag
    d.Attributes.Add &H40, &HA493, "VERIFIED"       ' Verification Flag
    
    ' ========== verifier - only needed if ststus is VERIFIED ==========
'    Set verifiers = New DicomDataSets
'    Set verifier = verifiers.AddNew
'    verifier.Attributes.Add &H40, &HA075, Reporter
'    verifier.Attributes.Add &H40, &HA027, "Medical Connections"
'    verifier.Attributes.Add &H40, &HA088, nullSequence
'    verifier.Attributes.Add &H40, &HA030, Now
'    d.Attributes.Add &H40, &HA073, verifiers
    ' ========== End verifier ==========
    
    'Overall Title etc.
    AddSequenceItem d, &HA043, "11528-7", "LN", "Radiology Report"  ' Concept Name Code Sequence
    AddContentCODE d, "HAS CONCEPT MOD", "121049", "DCM", "Language", "eng", "ISO639_2", "English"
    
    'Observer details
    AddContentCODE d, "HAS OBS CONTEXT", "121005", "DCM", "Observer Type", "121006", "DCM", "Person"
    AddContentPNAME d, "HAS OBS CONTEXT", "121008", "DCM", "Person Observer Name", Reporter
    
    Set history = AddContentCONTAINER(d, "CONTAINS", "121060", "DCM", "History", "SEPARATE")
    AddContentTEXT history, "CONTAINS", "121060", "DCM", "History", HistoryText
    
    Set findings = AddContentCONTAINER(d, "CONTAINS", "121070", "DCM", "Findings", "SEPARATE")
    AddContentTEXT findings, "CONTAINS", "121071", "DCM", "Finding", FindingsText
    
    'This  example shows how you could add a measurement item (local coding scheme)
    AddContentNUM findings, "CONTAINS", "HW", "LOCAL", "Heart Width", 135.6, "mm", "UCUM", "millimetres"
        
    Set conclusions = AddContentCONTAINER(d, "CONTAINS", "121076", "DCM", "Conclusions", "SEPARATE")
    AddContentTEXT conclusions, "CONTAINS", "121077", "DCM", "Conclusion", ConclusionText
    
    ' Add Image Reference
    Set ImageRef = AddImageContainer(d, "CONTAINS", "121078", "DCM", "Image Reference", "SEPARATE")
    AddImageReference ImageRef
    
    ' Add All SR Attributes to the User Interface
    Dim attList As String
    attList = ""
    For Each att In d.Attributes
        If att.Exists Then
            If TypeName(att.Value) = "Object" Then
            attList = attList & "(" & hex4(att.Group) & ", " & hex4(att.Element) & ") --- " & att.VR & vbNewLine
            Else
            attList = attList & "(" & hex4(att.Group) & ", " & hex4(att.Element) & ") --- " & att.Value & "" & vbNewLine
            End If
        End If
    Next
    
    Text1.text = attList
    
    ' Save the SR file onto Disk
    CommonDialog1.DialogTitle = "Save SR Document As"
    CommonDialog1.ShowSave
    
    CommonDialog1.CancelError = False
    
    If CommonDialog1.FileName <> "" Then
    d.WriteFile CommonDialog1.FileName, True
    End If
    
    Text1.Enabled = True
End Sub

Private Sub Form_Load()
    Dim g As New DicomGlobal
    Me.Caption = Me.Caption & " DicomObjects v" & g.Version
End Sub

Private Sub LoadImage_Click()
    CommonDialog1.InitDir = GetSamplePath("SampleProjects", "SampleImages/2D")
    CommonDialog1.ShowOpen
    If CommonDialog1.FileName <> "" Then
        Viewer.Images.ReadFile CommonDialog1.FileName
    End If
End Sub

Sub AddSequenceItem(Parent As DicomDataSet, ElementID As Long, CodeValue As String, CodeScheme As String, CodeMeaning As String)
    Dim ds1 As New DicomDataSets
    Dim d1 As New DicomDataSet
    
    ' Add code sequence
    d1.Attributes.Add 8, &H100, CodeValue   ' Code Value
    d1.Attributes.Add 8, &H102, CodeScheme  ' Code Scheme Designator
    d1.Attributes.Add 8, &H104, CodeMeaning ' Code Meaning
    
    ds1.Add d1
    Parent.Attributes.Add &H40, ElementID, ds1
End Sub

Function AddContentItem(Parent As DicomDataSet, Sequence As Long, Relationship As String, CodeValue As String, CodeScheme As String, CodeMeaning As String) As DicomDataSet
    Dim ds As New DicomDataSets, NewItem As DicomDataSet
    If Not Parent.Attributes(&H40, Sequence).Exists Then
        Set ds = New DicomDataSets
        Parent.Attributes.Add &H40, Sequence, ds
    Else
        Set ds = Parent.Attributes(&H40, Sequence).Value
    End If
    
    Set NewItem = ds.AddNew
    
    AddSequenceItem NewItem, &HA043, CodeValue, CodeScheme, CodeMeaning
    NewItem.Attributes.Add &H40, &HA010, Relationship   ' Relationship Type
    Set AddContentItem = NewItem
End Function

Sub AddImageReference(Parent As DicomDataSet)
   Dim d As New DicomDataSet
   Dim ds As New DicomDataSets

   d.Attributes.Add &H8, &H1150, Viewer.CurrentImage.SOPClass     ' Referenced SOP Class UID, CT For Example
   d.Attributes.Add &H8, &H1155, Viewer.CurrentImage.InstanceUID    'Referenced SOP Instance UID
   ds.Add d

   Parent.Attributes.Add &H8, &H1199, ds ' Referenced SOP Sequence
End Sub

Function AddContentTEXT(Parent As DicomDataSet, Relationship As String, CodeValue As String, CodeScheme As String, CodeMeaning As String, text As String) As DicomDataSet
    Dim d As DicomDataSet ' d is the new leaf to be insrted into parent
    Set d = AddContentItem(Parent, &HA730, Relationship, CodeValue, CodeScheme, CodeMeaning)
    d.Attributes.Add &H40, &HA160, text
    d.Attributes.Add &H40, &HA040, "TEXT"
End Function

Function AddContentNUM(Parent As DicomDataSet, Relationship As String, CodeValue As String, CodeScheme As String, CodeMeaning As String, Value As Single, UnitCodeValue As String, UnitCodeScheme As String, UnitCodeMeaning As String) As DicomDataSet
    Dim seq As New DicomDataSets
    Dim seqitem As DicomDataSet
    Set seqitem = seq.AddNew
    Dim d As DicomDataSet
    
    Set d = AddContentItem(Parent, &HA730, Relationship, CodeValue, CodeScheme, CodeMeaning)
    seqitem.Attributes.Add &H40, &HA30A, Value
    AddSequenceItem seqitem, &H8EA, UnitCodeValue, UnitCodeScheme, UnitCodeMeaning
    
    d.Attributes.Add &H40, &HA040, "NUM"    ' Value Type
    d.Attributes.Add &H40, &HA300, seq      ' Measured Value Sequence
End Function

Function AddContentPNAME(Parent As DicomDataSet, Relationship As String, CodeValue As String, CodeScheme As String, CodeMeaning As String, Name As String) As DicomDataSet
    Dim d As DicomDataSet ' d is the new leaf to be inserted into parent
    Set d = AddContentItem(Parent, &HA730, Relationship, CodeValue, CodeScheme, CodeMeaning)
    
    d.Attributes.Add &H40, &HA123, Name     ' Person Name
    d.Attributes.Add &H40, &HA040, "PNAME"  ' Value Type = "PNAME"
End Function

Function AddContentCODE(Parent As DicomDataSet, Relationship As String, CodeValue As String, CodeScheme As String, CodeMeaning As String, CodeValue2 As String, CodeScheme2 As String, CodeMeaning2 As String) As DicomDataSet
    Dim d As DicomDataSet  ' d is the new leaf to be inserted into parent
    Set d = AddContentItem(Parent, &HA730, Relationship, CodeValue, CodeScheme, CodeMeaning)
    d.Attributes.Add &H40, &HA040, "CODE"   ' Value Type
    AddSequenceItem d, &HA168, CodeValue2, CodeScheme2, CodeMeaning2 ' Concept Code Sequence
End Function

Function AddImageContainer(Parent As DicomDataSet, Relationship As String, CodeValue As String, CodeScheme As String, CodeMeaning As String, Continuity As String) As DicomDataSet
    Dim d As DicomDataSet
    Set d = AddContentItem(Parent, &HA730, Relationship, CodeValue, CodeScheme, CodeMeaning)
    d.Attributes.Add &H40, &HA040, "IMAGE"      ' Value Type
    d.Attributes.Add &H40, &HA050, Continuity   ' Continuity Of Content
    Set AddImageContainer = d
End Function

Function AddContentCONTAINER(Parent As DicomDataSet, Relationship As String, CodeValue As String, CodeScheme As String, CodeMeaning As String, Continuity As String) As DicomDataSet
    Dim d As DicomDataSet ' d is the new leaf to be inserted into parent
    Set d = AddContentItem(Parent, &HA730, Relationship, CodeValue, CodeScheme, CodeMeaning)
    
    d.Attributes.Add &H40, &HA040, "CONTAINER"  ' Value Type
    d.Attributes.Add &H40, &HA050, Continuity   ' Continuity Of Content
   
    Set AddContentCONTAINER = d
End Function

Function hex4(ByVal v)
   hex4 = Right("000" & Hex(v), 4)
End Function
