unit MWL;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleCtrls, DicomObjects8_TLB;

type
  TForm1 = class(TForm)
    PatientName: TEdit;
    PatientID: TEdit;
    StudyDate: TEdit;
    Modality: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    ServerLocalHost: TRadioButton;
    ServerMitra: TRadioButton;
    Port: TEdit;
    Label5: TLabel;
    Node: TEdit;
    CalledAE: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure ServerMitraClick(Sender: TObject);
    procedure ServerLocalHostClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);

var
  q: DicomQuery;
  result: DicomDataSets;
  res: DicomDataSet;
  seqitem: DicomDataSet;
  seq: DicomDataSets;
  ds: DicomDataSet;
  resseqitem: DicomDataSet;
  resseq: DicomDataSets;
  x: integer;
  v: Variant;

begin
  q := coDicomQuery.Create;
  seqitem := coDicomDataSet.Create;
  seq := coDicomDataSets.Create;
  ds := coDicomDataSet.Create;

  If ServerLocalHost.Checked Then
  begin
    q.Node := 'localhost';
    q.Port := 104;
    q.CalledAE := 'DicomObjectsSCP';
  end
  else
  begin
    q.Node := Node.Text;
    q.Port := StrToInt(Port.Text);
    q.CalledAE := Node.Text;
  end;

  q.CallingAE := 'MEDCONN';
  ds.Name := PatientName.Text;
  ds.PatientID := PatientID.Text;
  seqitem.Attributes.Add($40, 2, StudyDate.Text);
  seqitem.Attributes.Add($40, 3, '');
  seqitem.Attributes.Add($8, $60, Modality.Text);
  seq.Add(seqitem);
  ds.Attributes.Add($40, $100, seq);
  ds.Attributes.Add($8, $50, ''); // blank = send me the value please!
  ds.Attributes.Add($10, $30, ''); // blank = send me the value please!
  q.Root := 'WORKLIST';

  result := coDicomDataSets.Create;
  result := q.DoRawQuery(ds);

  If result.Count = 0 Then
  begin
    Memo1.Text := 'No results found';
  end
  Else
  begin
    Memo1.Text := '';
  End;

  x := 1;
  while x <= result.Count do
  begin
    res := coDicomDataSet.Create;
    res := result.Item[x];
    x := x + 1;

    v := res.Attributes.Item[$10, $30].Value;
    varcast(v, v, 8);

    resseq := coDicomDataSets.Create;
    resseqitem := coDicomDataSet.Create;
    Memo1.Text := Memo1.Text + 'Name=' + res.Name + ''#9#9 + 'ID=' +
      res.PatientID + ''#9 + 'Accession num=' + res.Attributes.Item[8, $50]
      .Value + ''#9 + 'DOB=' + v + ' '#13#10;
  end;

end;

procedure TForm1.ServerMitraClick(Sender: TObject);
begin

  Port.ReadOnly := false;
  Port.Color := clWhite;
  Node.ReadOnly := false;
  Node.Color := clWhite;
  CalledAE.ReadOnly := false;
  CalledAE.Color := clWhite;

end;

procedure TForm1.ServerLocalHostClick(Sender: TObject);
begin

  Port.ReadOnly := true;
  Port.Color := clBtnFace;
  Node.ReadOnly := true;
  Node.Color := clBtnFace;
  CalledAE.ReadOnly := true;
  CalledAE.Color := clBtnFace;

end;

end.
