VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "MPPS SCU"
   ClientHeight    =   2064
   ClientLeft      =   -12
   ClientTop       =   276
   ClientWidth     =   4476
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2064
   ScaleWidth      =   4476
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Complete 
      Caption         =   """Complete"" Notification"
      Height          =   615
      Left            =   2400
      TabIndex        =   1
      Top             =   1200
      Width           =   1935
   End
   Begin VB.CommandButton InProgress 
      Caption         =   """In Progress"" Notification"
      Height          =   615
      Left            =   120
      TabIndex        =   0
      Top             =   1200
      Width           =   1935
   End
   Begin VB.Label Label1 
      Caption         =   $"MPPS_SCU.frx":0000
      Height          =   852
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   4092
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim emptydss As DicomDataSets
Dim UID As String, StudyUID As String

Function MakeBaseDataSet() As DicomDataSet
    Dim ds As New DicomDataSet
    Set emptydss = New DicomDataSets
    
    'set up procedure  details
    ds.Name = "Bloggs^Joe"
    ds.PatientID = "ID1"
    ds.Sex = "M"
    ds.DateOfBirth = "31/12/62"

    'Patient
    ds.Attributes.Add &H8, &H1120, emptydss '"Referenced Patient Sequence"

    'This has basically the info returend in 0040,0100 from MWL
    Dim dds As New DicomDataSets
    Dim ds1 As New DicomDataSet
    
    ds1.StudyUID = StudyUID ' study uidERROR: Type 2 Attribute not present: -
    ds1.Attributes.Add &H8, &H1110, emptydss  ' "Referenced Study Sequence"
    ds1.Attributes.Add &H8, &H50, "12345"   ' "Accession Number"
    ds1.Attributes.Add &H40, &H1001, "REQ_ID1" '"Requested Procedure ID"
    ds1.Attributes.Add &H32, &H1060, "Requested Procedure Description"
    ds1.Attributes.Add &H40, &H9, "STEP_ID1" '"Scheduled Procedure Step ID"
    ds1.Attributes.Add &H40, &H7, "Scheduled Procedure Step Description"

    ds1.Attributes.Add &H40, &H8, emptydss    ' "Scheduled Action Item Code Sequence"
    
    dds.Add ds1
    ds.Attributes.Add &H40, &H270, dds '"Scheduled Step Attribute Sequence"

    ds.Attributes.Add &H40, &H241, "AETitle" ' "Station AE Title"
    ds.Attributes.Add &H40, &H242, "Station Name" ' Performed Station Name
    ds.Attributes.Add &H40, &H243, "Location" ' Performed Location"
    ds.Attributes.Add &H40, &H244, Now '"Performed Procedure Step Start Date"
    ds.Attributes.Add &H40, &H245, Now '"Performed Procedure Step Start Time"
    ds.Attributes.Add &H40, &H253, "1" '"Performed Procedure Step ID"
    ds.Attributes.Add &H40, &H250, "" '"Performed Procedure Step End Date" - not known yet
    ds.Attributes.Add &H40, &H251, "" '"Performed Procedure Step End Time"- not known yet
    ds.Attributes.Add &H40, &H254, "Performed Procedure Step Description"
    ds.Attributes.Add &H40, &H255, "Performed Procedure Type Description"
    ds.Attributes.Add &H8, &H60, "CT"
    ds.Attributes.Add &H20, &H10, "ID1" ' "Study ID"

    Set MakeBaseDataSet = ds
End Function

Function NegotiateAndConnect() As DicomConnection
    Dim cn As New DicomConnection
    Dim cxt As DicomContext
    
    'negotiate
    Set cxt = cn.Contexts.Add("1.2.840.10008.3.1.2.3.3") 'doSOP_ModalityPerformedProcedureStep
    cxt.OfferedTS = "1.2.840.10008.1.2" ' keeps AGFA tool happy!
    cn.SetDestination "localhost", 104, "CALLING_AE", "CALLED_AE"

    Set NegotiateAndConnect = cn
End Function

Private Sub InProgress_Click()
    
    Dim ds As DicomDataSet, cn As DicomConnection
    
    Set ds = MakeBaseDataSet
    Set cn = NegotiateAndConnect
    
    ' following sequences are blank at this stage (filled in when MPPS complete)
    ' but they must still be present
    
    ds.Attributes.Add &H40, &H260, emptydss '"Performed Action Item Sequence"
    ds.Attributes.Add &H8, &H1032, emptydss '"Procedure Code Sequence"
    ds.Attributes.Add &H40, &H340, emptydss ' "Performed Series Sequence"

    ds.Attributes.Add &H40, &H252, "IN PROGRESS"
    
    cn.NCreate "1.2.840.10008.3.1.2.3.3", UID, ds
    
    If cn.LastStatus = 0 Then MsgBox "Succeeded"
    
    cn.Close
    
End Sub
Private Sub Complete_Click()
    Dim ds As DicomDataSet, cn As DicomConnection
    Dim performeditem As New DicomDataSet
    Dim performedsequence As New DicomDataSets
    Dim actionitem As New DicomDataSet
    Dim actionsequence As New DicomDataSets
    Set ds = MakeBaseDataSet
    Set cn = NegotiateAndConnect
    
    'These code values are arbitrary, and would be mapped to local/defined codes for real use
    'There is scope for adding more detail of the examination here if required -
    ' - see the DICOM standard for details
    
    'Performed Action Item Sequence
    actionitem.Attributes.Add &H8, &H100, "PAI-1"
    actionitem.Attributes.Add &H8, &H102, "DCMOBJ"
    actionitem.Attributes.Add &H8, &H104, "Performed Action Item 1"
    actionsequence.Add actionitem
    ds.Attributes.Add &H40, &H260, actionsequence
    
    'Procedure Code Sequence
    performeditem.Attributes.Add &H8, &H100, "PC-1"
    performeditem.Attributes.Add &H8, &H102, "DCMOBJ"
    performeditem.Attributes.Add &H8, &H104, "Procedure Code 1"
    performedsequence.Add performeditem
    ds.Attributes.Add &H8, &H1032, performedsequence
    
    ds.Attributes.Add &H40, &H340, emptydss ' "Performed Series Sequence"

    ds.Attributes.Add &H40, &H252, "COMPLETED"
    
    cn.NSet "1.2.840.10008.3.1.2.3.3", UID, ds
    
    If cn.LastStatus = 0 Then MsgBox "Succeeded"
    
    cn.Close

End Sub

Private Sub Form_Load()
    Dim g As New DicomGlobal
    UID = g.NewUID
    StudyUID = g.NewUID
    Me.Caption = Me.Caption & " DO v" & g.Version
End Sub
