Attribute VB_Name = "Utilities"
' Utilities
Sub LogEvent(msg As String, PatientID As String, severity As Integer)
    DBExecute ("Insert into DICOM.dbo.Events (Severity, PatientID, Description) values(" & severity & ",'" & PatientID & "','" & MakeLegalFileName(msg) & "')")
End Sub
Sub LogInfo(msg As String, PatientID As String)
    LogEvent msg, PatientID, 0
End Sub
Sub LogError(msg As String, PatientID As String)
    LogEvent msg, PatientID, 1
    If debugging Then MsgBox msg
End Sub

Sub LogFatalError(msg As String, PatientID As String)
    LogEvent msg, PatientID, 2
    If debugging Then MsgBox msg
End Sub
Function DateToSQL(ByVal d As Date) As String
    DateToSQL = Format(d, "yyyy-mm-dd")
End Function
Function MakeLegalFileName(ByVal x) As String
    Dim z As Integer
    x = Trim(x)
    Do
        z = InStr(x, " ")
        If z Then Mid(x, z, 1) = "_"
    Loop While z > 0
    Do
        z = InStr(x, "/")
        If z Then Mid(x, z, 1) = "_"
    Loop While z > 0
    Do
        z = InStr(x, "'")
        If z Then Mid(x, z, 1) = "_"
    Loop While z > 0
    MakeLegalFileName = x
End Function

Function MakeInsertString(Image As DicomImage, r As Recordset) As String
    Dim title As String, forename As String, middlename As String, surname As String
    Dim Result As String
    Dim Value As Variant, name As String
    
    Result = ""
    r.MoveFirst
    While Not r.EOF
        name = Trim("@" & r!fieldname)
        Value = Image.Attributes(r!groupid, r!ElementID).Value
        If r!isName Then
            If IsNull(Value) Then
                Result = Result & name & "_first=NULL," & name & "_middle=NULL," & name & "_last=NULL," & name & "_title=NULL"
            Else
                SplitName Value, title, forename, middlename, surname
                Result = Result & name & "_first='" & forename & "'," & name & "_middle='" & middlename & "'," & name & "_last='" & surname & "'," & name & "_title='" & title & "'"
            End If
        Else
            Result = Result & name & "="
            If IsNull(Value) Then
                Result = Result & "NULL"
            ElseIf VarType(Value) = vbDate Then
                Result = Result & "'" & DateToSQL(Value) & "'"
            Else
                Result = Result & "'" & Value & "'"
            End If
        End If
        r.MoveNext
        If Not r.EOF Then Result = Result & ","
    Wend
    MakeInsertString = Result
End Function
Sub SplitName(ByVal name As String, ByRef title As String, ByRef forename As String, ByRef middlename As String, ByRef surname As String)
    Dim z As Integer
    Dim last As String, name1 As String
    Dim p As Integer, p2 As Integer
    On Error Resume Next
    name = Trim(name)
    z = InStr(name, "^")
    If z Then ' proper DICOM name
        name = name & "^^^^^"
        surname = Left(name, z - 1)
        name = Mid(name, z + 1)
        z = InStr(name, "^")
        forename = Left(name, z - 1)
        name = Mid(name, z + 1)
        
        z = InStr(name, "^")
        middlename = Left(name, z - 1)
        name = Mid(name, z + 1)
        
        z = InStr(name, "^")
        title = Left(name, z - 1)
        name = Mid(name, z + 1)
    Else
        last = name
        name1 = name
        z = InStr(name1, ",")
        If z = 0 Then z = InStr(name1, " ")
        If z = 0 Then
            surname = name
        Else
        
            surname = Left(name1, z - 1)
            forename = Mid(name1, z + 1)
            title = ""
            Do
                p2 = p
                p = InStr(last, " ")
                If p > 0 Then last = Mid(last, p + 1)
            Loop While p > 0
            If UCase(last) = last And UCase(name) <> name Then
                surname = last
                forename = Left(name, Len(name) - Len(last) - 1)
            End If
        End If
    End If
    title = Trim(title)
    forename = Trim(forename)
    surname = Trim(surname)
    middlename = Trim(middlename)
End Sub
Sub MakePath(filename As String)
    Dim p As Integer
    Dim path As String
    p = 1
    p = InStr(p + 1, filename, "\")

    While p > 0
        path = Left(filename, p - 1)
        On Error Resume Next
        MkDir path
        On Error GoTo 0
        p = InStr(p + 1, filename, "\")
    Wend
End Sub
Function StarToPercent(ByVal a As String) As String
    Dim z As Integer
    While InStr(a, "*")
        z = InStr(a, "*")
        a = Left(a, z - 1) & "%" & Mid(a, z + 1)
    Wend
    StarToPercent = a
End Function
Sub AddWhereOrAnd(ByRef Criteria As String)
    If Criteria = "" Then
        Criteria = "WHERE "
    Else
        Criteria = Criteria & " AND "
    End If

End Sub

Sub AddStringCriterion(ByRef Criteria As String, ByVal fieldname As String, ByVal val As Variant)
    If IsArray(val) Then
        If UBound(val, 1) > 0 Then
            Dim i As Integer
            AddWhereOrAnd Criteria
            Criteria = Criteria & " ( "
            For i = LBound(val, 1) To UBound(val, 1)
                If i <> LBound(val, 1) Then
                    Criteria = Criteria & " OR "
                End If
            Criteria = Criteria & fieldname & " LIKE '" & StarToPercent(val(i)) & "'"
            Next
            Criteria = Criteria & " ) "
        End If
    Else
        If val <> "" Then
            AddWhereOrAnd Criteria
            Criteria = Criteria & fieldname & " LIKE '" & StarToPercent(val) & "'"
        End If
    End If
End Sub
Sub AddMatchCriterion(ByRef Criteria As String, ByVal FieldMatch As String, ByVal val As Variant)
    If IsArray(val) Then
        If UBound(val, 1) > 0 Then
            Dim i As Integer
            AddWhereOrAnd Criteria
            Criteria = Criteria & " ( "
            For i = LBound(val, 1) To UBound(val, 1)
                If i <> LBound(val, 1) Then
                    Criteria = Criteria & " OR "
                End If
            Criteria = Criteria & "EXISTS ( " & FieldMatch & " '" & StarToPercent(val(i)) & "')"
            Next
            Criteria = Criteria & " ) "
        End If
    Else
        If val <> "" Then
            AddWhereOrAnd Criteria
            Criteria = Criteria & "EXISTS ( " & FieldMatch & " '" & StarToPercent(val) & "')"
        End If
    End If
End Sub

Sub AddNameCriterion(ByRef Criteria As String, ByVal fieldname As String, ByVal val As DicomAttribute)
    Dim first As String, middle As String, last As String, title As String
    If val.Value <> "" Then
        SplitName val.Value, title, first, middle, last
        If last <> "" Then AddStringCriterion Criteria, fieldname & "_last", last
        If first <> "" Then AddStringCriterion Criteria, fieldname & "_first", first
        If middle <> "" Then AddStringCriterion Criteria, fieldname & "_middle", middle
    End If
End Sub

Sub AddDateCriterion(ByRef Criteria As String, ByVal fieldname As String, ByVal val As DicomAttribute)
    If Not IsNull(val.Value) Then
        AddWhereOrAnd Criteria
        Criteria = Criteria & fieldname & " >= '" & DateToSQL(val.DateTimeFrom("1/1/1800")) & "' AND "
        Criteria = Criteria & fieldname & " <= '" & DateToSQL(val.DateTimeTo("1/1/2200")) & "'"
    End If
End Sub

Sub BackSlashToArray(ByRef v As Variant)
    If InStr(v, "\") = 0 Then Exit Sub
    
    Dim i As Integer, p As Integer
    Dim newv() As String
    ReDim newv(100)
    i = 0
    v = v & "\"
    While v <> ""
        p = InStr(v, "\")
        If p > 1 Then
            i = i + 1
            newv(i) = Left(v, p - 1)
        End If
        v = Mid(v, p + 1)
    Wend
    ReDim Preserve newv(i)
    v = newv
    
End Sub

