VERSION 5.00
Begin VB.Form ServerForm 
   Caption         =   "Sample Dicom Server"
   ClientHeight    =   2292
   ClientLeft      =   60
   ClientTop       =   348
   ClientWidth     =   4440
   LinkTopic       =   "Form1"
   ScaleHeight     =   2292
   ScaleWidth      =   4440
   StartUpPosition =   3  'Windows Default
   Begin VB.Label Se 
      Caption         =   "Server has no GUI - After testing this project can be converted to run as a service"
      Height          =   1095
      Left            =   240
      TabIndex        =   0
      Top             =   480
      Width           =   3855
   End
End
Attribute VB_Name = "ServerForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim debugging As Boolean
Dim WithEvents Server As DicomServer
Attribute Server.VB_VarHelpID = -1
' Recordsets below are kept permanently open
Dim Configuration As Recordset, PatientInfo As Recordset, StudyInfo As Recordset, SeriesInfo As Recordset, ImageInfo As Recordset, FilenameInfo As Recordset

Private Sub Form_Load()
    Dim g As New DicomGlobal
    Me.Caption = Me.Caption & " DO v" & g.Version
    debugging = True
    If Not OpenDataBase Then
        Unload Me
        Exit Sub
    End If
    LoadStaticRecordSets
    InitialiseDICOM
End Sub

Sub LoadStaticRecordSets()
    Set Configuration = DBExecute("Select * from DICOM.dbo.Configuration")
    'Set Configuration = DBExecute("Select * from DICOM.dbo.Fields where Patient =1")
    Set PatientInfo = DBExecute("Select * from DICOM.dbo.Fields where PATIENT=1 and ForStoring=1 order by GroupID,ElementID")
    Set StudyInfo = DBExecute("Select * from DICOM.dbo.Fields where STUDYPATIENT=1 and ForStoring=1 order by GroupID,ElementID")
    Set SeriesInfo = DBExecute("Select * from DICOM.dbo.Fields where SERIES=1 and ForStoring=1 order by GroupID,ElementID")
    Set ImageInfo = DBExecute("Select * from DICOM.dbo.Fields where IMAGE=1 and ForStoring=1 order by GroupID,ElementID")
    Set FilenameInfo = DBExecute("Select * from DICOM.dbo.Fields where FILENAME=1 and ForStoring=1 order by GroupID,ElementID")

End Sub

Sub InitialiseDICOM()
    Dim port As Long
    port = Configuration!LocalPort
    
    Set Server = New DicomServer
    
    Server.DefaultStatus = &HC000
    
    If Server.Listen(port) Then
        LogInfo "Listened succesfully on Port " & port, ""
    Else
        LogFatalError "Failed to LIsten on Port " & port, ""
    End If
End Sub


Private Sub Server_ActionComplete(ByVal Connection As DicomObjects8.DicomConnection, ByVal Action As String, ByVal Tag As Variant, ByVal Success As Boolean, ByVal ErrorMessage As String)
    If Not Success Then
        LogError ErrorMessage, ""
        On Error Resume Next
        Connection.Close
        On Error GoTo 0
        Exit Sub
    End If
    
    If Not debugging Then On Error GoTo er
       
    If Action = "SaveImage" Then
        'If successfully saved (succes is true if we get to here) then insert into database
        DBExecute Connection.Tag
        Connection.SendStatus 0
    ElseIf Action = "SetDestination" Then  ' C-MOVE handler
        FindAndSendImages Connection
    Else
        Connection.SendStatus 0
    
    End If
        
ExitPoint:
    Exit Sub
    
er:
    LogError Err.Description, ""
    Resume ExitPoint
End Sub

Private Sub Server_AssociationRequest(ByVal Connection As DicomObjects8.DicomConnection, isOK As Boolean)
LogInfo "Association request from " & Connection.CallingAET & " to " & Connection.CalledAET, ""
    'Reject unofficial SOP classes (get problems with GE if you don't)
    Dim cxt As DicomContext
    For Each cxt In Connection.Contexts
        If Left(cxt.AbstractSyntax, 14) <> "1.2.840.10008." Then
            cxt.Reject 3
        End If
    Next
    isOK = True
End Sub

Private Sub Server_InstanceReceived(ByVal Connection As DicomObjects8.DicomConnection, ByVal dataset As DicomObjects8.DicomDataSet)
    Dim filename As String
    'Dim Filenames As Recordset
    Dim count As Integer
    
    Dim col As New DicomImages
    col.Add dataset
    Dim Image As DicomImage
    Set Image = col.Item(1)
    
    If Not debugging Then On Error GoTo er
    
    count = DBExecute("DICOM.dbo.ImageExists '" & Image.InstanceUID & "'")!count
    If count = 0 Then
        filename = MakeLegalFileName(DBExecute("DICOM.dbo.GetFilename " & MakeInsertString(Image, FilenameInfo))!filename)
        
        DBExecute "DICOM.dbo.InsertPatient " & MakeInsertString(Image, PatientInfo)
        DBExecute "DICOM.dbo.InsertStudy " & MakeInsertString(Image, StudyInfo)
        DBExecute "DICOM.dbo.InsertSeries " & MakeInsertString(Image, SeriesInfo)
        
        'InsertImage is left until after SaveImage, to make sure thst it has been successful!
        'Text to insert is placed in Connection's Tag property
            
        MakePath filename
        Connection.Tag = "DICOM.dbo.InsertImage " & MakeInsertString(Image, ImageInfo) & ", @Filename='" & filename & "'"
        Connection.SaveImage Image, filename, True, "1.2.840.10008.1.2.4.57"
        LogInfo Image.InstanceUID & " saved to " & filename, Image.PatientID
    Else
        LogInfo "Duplicate received for " & Image.InstanceUID, Image.PatientID
        Connection.SendStatus 0
    End If
    
ExitPoint:
    Exit Sub
    
er:
    Connection.SendStatus &HA700
    LogError Err.Description & " : " & Err.Source, Image.PatientID
    Resume ExitPoint
End Sub

Private Sub Server_QueryRequest(ByVal Connection As DicomObjects8.DicomConnection)
    Dim level As String, root As String
    Dim values As String, Criteria As String
    Dim fields As Recordset
    Dim attrib As DicomAttribute, fieldname As String, fieldsource As String, FieldMatch As String
    Dim RemoteAE As Recordset
    Dim request As DicomDataSet
    Dim FindResults As DicomDataSets
    Dim resultset As Recordset
    Dim resultitem As DicomDataSet
    Dim Value As Variant

    If Not debugging Then On Error GoTo er
    
    'Basic query handling set up
    
    Set request = Connection.request
    level = request.Attributes(8, &H52)
    root = Connection.root
    Connection.CoercionSOP = doSOP_SecondaryCapture
    
    ' STUDY level (only) needs to be handled differently according to whether root s PATIENT or STUDY
    ' So we use internally 2 completely different "levels" STUDYSTUDY & STUDYPATIENT
    
    If level = "STUDY" Then level = level & root
    
    If Connection.Operation = "C-FIND" Then
        Set FindResults = New DicomDataSets
        
        Set fields = DBExecute("Select * from DICOM.dbo.Fields where " & level & "=1")
        
        While Not fields.EOF
            Set attrib = request.Attributes(fields!groupid, fields!ElementID)
            If attrib.Exists Then
                fieldname = Trim(fields!fieldname)
                fieldsource = Trim(fields!fieldsource)
                FieldMatch = ""
                If Not IsNull(fields!FieldMatch) Then FieldMatch = Trim(fields!FieldMatch)
                Value = attrib.Value
                ' First put into match list if necessary
                
                'This next procedure is for multivalued attributes, which are not generally treated as multi-valued
                '(such as UIDs), but MAY be multi-valued in queries.
                If VarType(Value) = vbString And attrib.VR <> "LT" And attrib.VR <> "ST" And attrib.VR <> "UT" Then
                    BackSlashToArray Value
                End If
                
                
                If fields!ForMatching And Not IsNull(Value) Then
                    If FieldMatch <> "" Then
                        AddMatchCriterion Criteria, FieldMatch, Value
                    ElseIf fields!isName Then
                        AddNameCriterion Criteria, fieldsource, attrib
                    ElseIf fields!IsDate Then
                        AddDateCriterion Criteria, fieldsource, attrib
                    Else
                        AddStringCriterion Criteria, fieldsource, Value
                    End If
                End If
                
                ' now put into returned values list
                If values <> "" Then values = values & ","
                If fields!isName Then
                    values = values & fieldsource & "_first," & fieldname & "_middle," & fieldname & "_last," & fieldname & "_title"
                Else
                    values = values & fieldsource & " AS " & fieldname
                End If
            End If
            fields.MoveNext
        Wend
        
        Set resultset = DBExecute("SELECT " & values & " FROM DICOM.dbo." & level & "View " & Criteria)
        
        While Not resultset.EOF
            Set resultitem = New DicomDataSet
            fields.MoveFirst
            While Not fields.EOF
                Set attrib = request.Attributes(fields!groupid, fields!ElementID)
                If attrib.Exists Then
                    fieldname = Trim(fields!fieldname)
                    If fields!isName Then
                        Value = resultset.fields(fieldname & "_last") & "^" & resultset.fields(fieldname & "_first") & "^" & resultset.fields(fieldname & "_middle") & "^" & resultset.fields(fieldname & "_title") & "^"
                    Else
                        Value = resultset.fields(fieldname)
                    End If
                    If IsNull(Value) Then
                        resultitem.Attributes.Add attrib.Group, attrib.Element, ""
                    Else
                        resultitem.Attributes.Add attrib.Group, attrib.Element, Value
                    End If
                End If
                fields.MoveNext
            Wend
            FindResults.Add resultitem
            resultset.MoveNext
        Wend
        Connection.Tag = "DoneFind"
        Connection.SendData FindResults, &HFF00

    ElseIf Connection.Operation = "C-GET" Or Connection.Operation = "C-MOVE" Then
    
        If Connection.Operation = "C-MOVE" Then
            Set RemoteAE = DBExecute("SELECT * from DICOM.dbo.RemoteAETs where remoteaet= '" & Connection.Destination & "'")
            If RemoteAE.EOF Then
                Connection.Errors.Attributes.Add 0, &H902, "Unknown Move Destination: " & Connection.Destination
                Connection.SendStatus (&HA801)
                LogError "Unknown Move Destination: " & Connection.Destination, ""
                Exit Sub
            End If
 
            Dim l As Long
            l = RemoteAE!port
            Connection.SetDestination RemoteAE!IPAddress, l, Configuration!LocalAET, Connection.Destination
        Else
            FindAndSendImages Connection
        End If
        
    End If

ExitPoint:
    Exit Sub

er:
    LogError Err.Description, ""
    Resume ExitPoint
End Sub


Private Sub FindAndSendImages(Connection As DicomConnection)
    Dim level As String
    Dim request As DicomDataSet
    
    Set request = Connection.request
    level = request.Attributes(8, &H52)

    If Not debugging Then On Error GoTo er
        
    Dim query As String, images As Recordset
    
    query = "SELECT Filename FROM DICOM.dbo.ImageRetrievalView "
  
    Select Case level
    Case "PATIENT"
        query = query & " WHERE PatientID='" & request.PatientID & "'"
    Case "STUDY"
        query = query & " WHERE StudyUID='" & request.StudyUID & "'"
    Case "SERIES"
        query = query & " WHERE SeriesUID='" & request.SeriesUID & "'"
    Case "IMAGE"
        query = query & " WHERE InstanceUID='" & request.InstanceUID & "'"
    End Select
    query = query & " ORDER BY studydate,studyuid,SeriesNumber,InstanceNumber"
    
    Set images = DBExecute(query)

    Dim fn(1000) As String
    Dim c As Integer
    c = 1
    Do Until images.EOF Or c >= UBound(fn, 1)
       fn(c) = images!filename
       c = c + 1
       images.MoveNext
    Loop
    
    If Connection.Operation = "C-MOVE" Then
        Connection.Tag = "DoneMove"
    Else
        Connection.Tag = "DoneGet"
    End If
    
    Connection.SendImages fn
    
ExitPoint:
    Exit Sub
    
er:
    LogError Err.Description, ""
    Resume ExitPoint
End Sub


Private Sub Server_VerifyReceived(Status As Long)
    Status = 0
End Sub

