﻿using System;
using DicomObjects;
using DicomObjects.EventArguments;
using Microsoft.Extensions.Logging;

namespace SCP
{
    class Program
    {
        private const int Port = 104;
        private const string PressAnyKeyToExit = "Press any key to exit";
        static void Main(string[] args)
        {
            DicomServer server = new DicomServer();

            ILoggerFactory loggerFactory = LoggerFactory.Create(config => config.AddConsole());
            ILogger logger = loggerFactory.CreateLogger<Program>();
            DicomGlobal.LogToLogger(logger, 0x3F);

            try
            {
                server.Listen(Port);
            }
            catch (DicomException ex)
            {
                DicomGlobal.Log(ex.Message);
                throw;
            }

            server.NormalisedReceived += Server_NormalisedReceived;

            DicomGlobal.Log(PressAnyKeyToExit);
            Console.ReadKey();
        }

        private static void Server_NormalisedReceived(object sender, NormalisedReceivedArgs e)
        {
            if (e.Operation == DicomObjects.Enums.DicomOperation.N_CREATE || e.Operation == DicomObjects.Enums.DicomOperation.N_SET)
            {
                e.Status = 0;
            }
            else
            {
                e.Status = 0xC001; // General Error
            }
        }

    }
}
