﻿using DicomObjects;
using DicomObjects.Enums;
using System;
using System.IO;

namespace MyHTJ2KCodec
{
    public class MyHTJ2KCodecFactory : DicomObjects.Codecs.CodecFactory
    {
        public override bool CheckStart(Stream stream, string TransferSyntax)
        {
            return true;
        }
        public override DicomObjects.Codecs.ICompressor Compressor(string TransferSyntax)
        {
            return new MyHTJ2KEncoder();
        }
        public override DicomObjects.Codecs.IDecompressor Decompressor(string TransferSyntax,
                    System.IO.Stream Data, DicomDataSet DataSet, int Frame)
        {
            return new MyHTJ2KDecoder(); ;
        }
        public override DicomObjects.Codecs.IExporter Exporter(string Format)
        {
            throw new NotImplementedException();
        }
        public override DicomObjects.Codecs.IImporter Importer(string Format)
        {
            throw new NotImplementedException();
        }
        public override string[] SupportedTransferSyntaxes(CodecOperation Operation)
        {
            return new string[] { "1.2.840.10008.1.2.4.201", "1.2.840.10008.1.2.4.202", "1.2.840.10008.1.2.4.203" };
        }
    }
}

