﻿using DicomObjects;
using DicomObjects.Internal.DicomCodecs;
using DicomObjects.UIDs;
using MyHTJ2KCodec;
using System;
using System.Diagnostics;
using System.IO;

namespace ConsoleAppCore3
{
    internal partial class Program
    {
        const string inputDir = @""; // input dcm's
        const string outputDir = @""; // output compressed/decompressed dcm's
        static void Main(string[] args)
        {
            CodecGlobal.RegisterCodec(new MyHTJ2KCodecFactory());

            bool compressTest = true;
            if (compressTest)
            {
                Console.WriteLine("Calling Compress");

                DirectoryInfo di = new DirectoryInfo(inputDir);
                foreach (var fi in di.GetFiles("*.dcm", SearchOption.TopDirectoryOnly))
                {
                    if (DicomGlobal.IsDICOM(fi.FullName))
                    {
                        DicomDataSet ds = new DicomDataSet(fi.FullName);
                        string outputFile = Path.Combine(outputDir, fi.Name + ".htj2k.dcm");
                        if (!Directory.Exists(outputDir))
                            Directory.CreateDirectory(outputDir);
                        Stopwatch sw = Stopwatch.StartNew();
                        ds.Write(outputFile, "1.2.840.10008.1.2.4.202"); // .203 for lossy
                        Console.WriteLine($"{sw.ElapsedMilliseconds} milliseconds to write to {outputFile}");
                        sw.Stop();
                    }
                }

                Console.WriteLine("FINISHED!");
            }
            else
            {
                DirectoryInfo di = new DirectoryInfo(outputDir);
                foreach (var fi in di.GetFiles("*.dcm", SearchOption.TopDirectoryOnly))
                {
                    if (DicomGlobal.IsDICOM(fi.FullName))
                    {
                        DicomDataSet ds = new DicomDataSet(fi.FullName);
                        string decompressedDir = Path.Combine(outputDir, "decompressed");
                        string outputFile = Path.Combine(decompressedDir, fi.Name + ".unc.dcm");
                        if (!Directory.Exists(decompressedDir))
                            Directory.CreateDirectory(decompressedDir);

                        Stopwatch sw = Stopwatch.StartNew();
                        ds.Write(outputFile, "1.2.840.10008.1.2.1");
                        Console.WriteLine($"{sw.ElapsedMilliseconds} milliseconds to write decompressed file - {outputFile}");
                    }
                }
                Console.WriteLine("FINISHED!");
            }
            Console.ReadLine();
        }
    }
}
