﻿using DicomObjects;
using DicomObjects.Enums;
using Microsoft.Extensions.Logging;
using System;

namespace Client
{
    class Program
    {
        static void Main(string[] args)
        {
            using var loggerFactory = LoggerFactory.Create(builder =>
            {
                builder
                    .AddConsole();
            });
            var logger = loggerFactory.CreateLogger<Program>();

            DicomGlobal.LogToLogger(logger, 0x3f);

            Console.WriteLine("Press any key to send a test image");
            Console.ReadLine();

            DicomPrint printer = new DicomPrint()
            {
                Colour = false,
                Format = "STANDARD\\1,1",
                Orientation = "PORTRAIT",
                FilmSize = "8INX10IN"
            };

            printer.Open("LocalHost", 104, "PrinterAE", "PrintClientAE");
            printer.FilmBox.Add(Keyword.MagnificationType, "NONE");

            DicomDataSet img = new DicomDataSet("ct.dcm");

            printer.PrintImage(img, true);

            printer.Close();

            Console.WriteLine("Press any key to exit...");
            Console.ReadLine();
        }
    }
}
