﻿using DicomObjects;
using DicomObjects.Enums;
using Microsoft.Extensions.Logging;
using Microsoft.VisualBasic;
using System;
using System.Text;

namespace SCU
{
    class Program
    {
        const bool ENABLE_LOGGING = false;
        static void Main(string[] args)
        {
            Console.WriteLine("Client Started!");

            if (ENABLE_LOGGING)
            {
                ILoggerFactory loggerFactory = LoggerFactory.Create(config => config.AddConsole());
                ILogger logger = loggerFactory.CreateLogger<Program>();
                DicomGlobal.LogToLogger(logger, 0x3F);
            }

            DicomQuery q = new DicomQuery();
            DicomDataSetCollection SQ = new DicomDataSetCollection();
            DicomDataSet ds = new DicomDataSet();
            DicomDataSet seqItem = new DicomDataSet();
            DicomDataSetCollection results;
            string prefix = " ";

            Console.WriteLine("Waiting for Query Results, Please Wait ... ...");


            q.Node = "localhost";
            q.Port = 110;
            q.CallingAE = "MWL_SCU";
            q.CalledAE = "MWL_SCP";
            q.Root = QueryRoot.ModalityWorklist;


            //Search Criteria
            string PatientName = "";
            string PatientID = "";
            string Modality = "";
            string testDate = DateTime.Now.ToString();

            // ============================ Type 1 Attributes ============================
            ds.Name = PatientName;
            ds.PatientID = PatientID;
            ds.Add(Keyword.StudyInstanceUID, "");
            ds.Add(Keyword.RequestedProcedureID, "");
            ds.Add(Keyword.RequestedProcedureDescription, "");

            // =======================  Scheduled Procedure Step SQ =======================
            seqItem.Add(Keyword.ScheduledStationAETitle, "");
            seqItem.Add(Keyword.ScheduledProcedureStepStartDate, "");
            seqItem.Add(Keyword.ScheduledProcedureStepStartTime, "");
            seqItem.Add(Keyword.ScheduledProcedureStepID, "");
            seqItem.Add(Keyword.Modality, Modality);


            SQ.Add(seqItem);
            ds.Add(Keyword.ScheduledProcedureStepSequence, SQ);

            results = q.Find(ds);

            if (results.Count == 0)
            {
                Console.WriteLine("No Results Returned");
                return;
            }

            StringBuilder temp = new StringBuilder();

            foreach (DicomDataSet result in results)
            {
                AppendAttributes(temp, prefix, result);
                temp.Append(" ============================================\r\n");
            }


            Console.WriteLine($"{results.Count} responses received");

            Console.WriteLine("Press Any key to exit!");
            Console.ReadKey();
        }

        private static void AppendAttributes(StringBuilder list, string prefix, DicomDataSet ob)
        {
            DicomAttribute at;
            DicomDataSetCollection s;
            int i;
            object v;

            for (int j = 0; j < ob.Count; j++)
            {
                at = ob[j];

                list.Append(prefix).Append("(").Append(at.Group.ToString("X4")).Append(",").Append(at.Element.ToString("X4")).Append(") : ");
                list.Append(at.Description.PadRight(30)).Append(": ");
                if ((at.Group == 0x7FE0 && at.Element == 0x0010)) // pixel data;
                {
                    list.Append("Pixel data").Append("\r\n");
                }
                else
                {
                    if (Information.VarType(at.Value) == VariantType.Object)  // i.e. a sequence;
                    {
                        s = (DicomDataSetCollection)at.Value;
                        if (s != null)
                        {
                            list.Append("Sequence of ").Append(s.Count).Append(" items:").Append("\r\n");
                            for (i = 0; i < s.Count; i++)
                            {
                                list.Append(prefix).Append(">---------------").Append("\r\n");
                                AppendAttributes(list, prefix + ">", s[i]);
                            }
                            list.Append(prefix).Append(">---------------");
                            list.Append("\r\n");
                        }
                        else
                        {
                            list.Append("\r\n");
                        }
                    }
                    else
                    {
                        v = at.Value; // could be variant or array;
                        if ((Information.VarType(v) >= VariantType.Array))  // i.e. an array;
                        {
                            Array a = v as Array;
                            list.Append("Multiple values :");
                            list.Append("\r\n");
                            list.Append("              ");

                            if (Information.UBound(a, 1) > 32)
                            {
                                list.Append("Array of ").Append(Information.UBound(a, 1)).Append(" elements");
                            }
                            else
                            {
                                for (i = Information.LBound(a, 1); i <= Information.UBound(a, 1); i++)
                                {
                                    list.Append(a.GetValue(i));
                                    if (i != Information.UBound(a, 1)) list.Append(" : ");
                                }
                            }
                            list.Append("\r\n");
                        }
                        else
                        {
                            if (at.VR == "DA" && Information.VarType(v) != VariantType.Null)
                            {
                                DateTime d;
                                d = (DateTime)v;
                                list.Append(d.ToShortDateString());
                                list.Append("\r\n");
                            }
                            else
                            {
                                if (at.VR == "TM" && Information.VarType(v) != VariantType.Null)
                                {
                                    DateTime d;
                                    d = (DateTime)v;
                                    list.Append(d.ToShortTimeString());
                                    list.Append("\r\n");
                                }
                                else
                                {
                                    list.Append(v);
                                    list.Append("\r\n");
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
