using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using DicomObjects;

namespace LicenceManager.Core5
{
    public partial class LicenceDialog : Form
    {
        public LicenceDialog()
        {
            InitializeComponent();
        }

        private void ActivateOnLine_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(AuthorisationString.Text) || string.IsNullOrEmpty(CustomerInfo1.Text) || string.IsNullOrEmpty(CustomerInfo2.Text))
            {
                MessageBox.Show("Please enter Licence Key, Customer Info 1 and 2");
                return;
            }

            try
            {
                var l = DicomLicence.ActivateOnLine(AuthorisationString.Text, CustomerInfo1.Text, CustomerInfo2.Text, out string res);
                var s = res + Environment.NewLine + l.ToString();
                MessageBox.Show(s);
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error activating licence Online - " + ex.Message);
            }
            finally
            {
                Close();
            }
        }

        private void ActivateOffLine_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(MachineID.Text) || string.IsNullOrEmpty(LicenseToken.Text) || string.IsNullOrEmpty(licenceKeyText.Text))
            {
                MessageBox.Show("Please enter Licence Key and Licence Token");
                return;
            }

            try
            {
                var l = DicomLicence.ActivateOffLine(licenceKeyText.Text, LicenseToken.Text, out string res);
                var s = res + Environment.NewLine + l.ToString();
                MessageBox.Show(s);
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error activating licence Offline - " + ex.Message);
            }
            finally
            {
                Close();
            }
        }

        private void LicenceDialog_Load(object sender, EventArgs e)
        {
            MachineID.Text = DicomLicence.MachineId;
        }
    }
}