#pragma once
#include <iostream>
#include "ojph_codestream.h"

extern "C" __declspec(dllexport) void* Create();

class OpenJPHWrapper {
public:
    uint8_t* Compress(const uint8_t* uncompressedData, size_t dataSize,
        char* photometricInterpretation, ojph::ui32 width,
        ojph::ui32 height, ojph::ui32 bitDepth,
        ojph::ui32 isSigned, ojph::ui32 planarConfig, size_t* compressedSize);

    uint8_t* Decompress(const uint8_t* compressedData, size_t dataSize,
        char* photometricInterpretation, ojph::ui32 planarConfig,
        size_t* decompressedSize);
};
