#pragma once
#include <ctime>
#include <iostream>
#include "ojph_arg.h"
#include "ojph_mem.h"
#include "ojph_img_io.h"
#include "ojph_file.h"
#include "ojph_codestream.h"
#include "ojph_params.h"
#include "pch.h"
//#include "ojph_message.h"

//#include <cstring>
//#include "ojph_message.h"

class OpenJPHWrapper {
public:
	uint8_t* Compress(const uint8_t* uncompressedData, size_t dataSize, char* photometricInterpretation, ojph::ui32 width, ojph::ui32 height,
		ojph::ui32 bitDepth, ojph::ui32 isSigned, ojph::ui32 planarConfig, char* transferSyntax, ojph::ui32 quality, size_t* compressedSize);
};

extern "C" _declspec(dllexport) uint8_t* Compress(OpenJPHWrapper* wrapper, const uint8_t*
	uncompressedData, size_t dataSize, char* photometricInterpretation, ojph::ui32 width, ojph::ui32 height,
	ojph::ui32 bitDepth, ojph::ui32 isSigned, ojph::ui32 planarConfig, char* transferSyntax, ojph::ui32 quality, size_t* compressedSize)
{
	return wrapper->Compress(uncompressedData, dataSize, photometricInterpretation, width, height, bitDepth, isSigned, planarConfig, transferSyntax, quality, compressedSize);
}

