#pragma once
#include <ctime>
#include <iostream>
#include "ojph_arg.h"
#include "ojph_mem.h"
#include "ojph_img_io.h"
#include "ojph_file.h"
#include "ojph_codestream.h"
#include "ojph_params.h"
#include "pch.h"
class OpenJPHWrapper {
public:
    uint8_t* Decompress(const uint8_t* compressedData, size_t dataSize, char* photometricInterpretation, ojph::ui32 planarConfig, size_t* decompressedSize);
};

extern "C" _declspec(dllexport) uint8_t* Decompress(OpenJPHWrapper* wrapper, const uint8_t* compressedData, size_t dataSize,
    char* photometricInterpretation, ojph::ui32 planarConfig, size_t* decompressedSize)
{
    return wrapper->Decompress(compressedData, dataSize, photometricInterpretation, planarConfig, decompressedSize);
}

