﻿using DicomObjects;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Extensions.Logging;


namespace TestClient2
{
    public static class Utils
    {
        public static void Dump(string methodName, IEnumerable<DicomDataSet> results)
        {
            LoggerHelper.LogText($"============={methodName}=============");
            int count = 1;
            foreach (var ds in results)
            {
                LoggerHelper.LogText($"================returned result #{count}===================");
                foreach (var at in ds)
                {
                    if (at.KeywordCode == DicomObjects.Enums.Keyword.PixelData)
                    {
                        LoggerHelper.LogText($"({at.Group:X4}, {at.Element:X4}) : {at.Description}");
                    }
                    else
                    {
                        LoggerHelper.LogText($"({at.Group:X4}, {at.Element:X4}) : {at.Description} : {at.Value}");
                    }
                }
                count++;
            }
            LoggerHelper.LogText($"================End of {methodName}==================");
        }
    }
}
